/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client;

import net.minecraft.block.Block;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.RegistrySimple;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.ProxyClient;
import pl.asie.foamfix.client.Deduplicator;
import pl.asie.foamfix.shared.FoamFixShared;

public class FoamFixModelDeduplicate {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onModelBake(ModelBakeEvent event) {
        if (FoamFixShared.config.clDeduplicate) {
            ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"FoamFix: deduplicating", (int)((RegistrySimple)event.modelRegistry).func_148742_b().size());
            if (ProxyClient.deduplicator == null) {
                ProxyClient.deduplicator = new Deduplicator();
            }
            FoamFix.logger.info("Deduplicating models...");
            ProxyClient.deduplicator.maxRecursion = FoamFixShared.config.clDeduplicateRecursionLevel;
            ProxyClient.deduplicator.addObjects(Block.field_149771_c.func_148742_b());
            ProxyClient.deduplicator.addObjects(Item.field_150901_e.func_148742_b());
            for (ModelResourceLocation loc : ((RegistrySimple)event.modelRegistry).func_148742_b()) {
                IBakedModel model = (IBakedModel)event.modelRegistry.func_82594_a((Object)loc);
                String modelName = loc.toString();
                bakeBar.step(String.format("[%s]", modelName));
                try {
                    ProxyClient.deduplicator.addObject(loc);
                    ProxyClient.deduplicator.deduplicateObject(model, 0);
                }
                catch (Exception exception) {}
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
            FoamFix.logger.info("Deduplicated " + ProxyClient.deduplicator.successfuls + " objects.");
        }
        ProxyClient.deduplicator = null;
        FoamFix.updateRamSaved();
    }
}

