/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="forgivingvoid", name="Forgiving Void", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.10.2]")
@Mod.EventBusSubscriber
public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";
    private static Logger logger = LogManager.getLogger((String)"forgivingvoid");
    private static List<Integer> dimensionBlacklist = Lists.newArrayList();

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ForgivingVoid.updateDimensionBlacklist();
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            if (ForgivingVoid.isEnabledForDimension(event.player.field_71093_bK) && event.player.field_70163_u < (double)ModConfig.triggerAtY) {
                event.player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 3));
                if (event.player.func_184207_aI()) {
                    event.player.func_184226_ay();
                }
                if (event.player.func_184218_aH()) {
                    event.player.func_184210_p();
                }
                ((EntityPlayerMP)event.player).field_184851_cj = true;
                event.player.func_70634_a(event.player.field_70165_t, (double)ModConfig.fallingHeight, event.player.field_70161_v);
                event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", true);
            } else if (event.player.getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
                if (event.player.func_70090_H() || event.player.field_70134_J || event.player.field_71075_bZ.field_75100_b || event.player.field_71075_bZ.field_75101_c) {
                    event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
                    ((EntityPlayerMP)event.player).field_184851_cj = false;
                    return;
                }
                if (ModConfig.disableVanillaAntiCheatWhileFalling) {
                    ((EntityPlayerMP)event.player).field_184851_cj = true;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && event.getEntity().getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
            if (ModConfig.disableVanillaAntiCheatWhileFalling) {
                ((EntityPlayerMP)event.getEntity()).field_184851_cj = false;
            }
            if (!event.isCanceled()) {
                float finalDamage;
                float damage = ModConfig.damageOnFall;
                if (ModConfig.preventDeath && event.getEntityLiving().func_110143_aJ() - damage <= 0.0f) {
                    damage = event.getEntityLiving().func_110143_aJ() - 1.0f;
                }
                if ((finalDamage = damage * Math.max(1.0f, event.getDamageMultiplier())) > 0.0f) {
                    event.getEntity().func_70097_a(DamageSource.field_76379_h, finalDamage);
                }
            }
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
            event.getEntity().getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (MOD_ID.equals(event.getModID())) {
            ConfigManager.load((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
            ForgivingVoid.updateDimensionBlacklist();
        }
    }

    private static void updateDimensionBlacklist() {
        dimensionBlacklist.clear();
        for (String dimension : ModConfig.dimensionBlacklist) {
            try {
                dimensionBlacklist.add(Integer.parseInt(dimension));
            }
            catch (NumberFormatException e) {
                logger.error("Invalid dimension blacklist entry {}, expected numeric id", new Object[]{dimension});
            }
        }
    }

    private static boolean isEnabledForDimension(int dimension) {
        if (dimension == 0) {
            return ModConfig.triggerInOverworld;
        }
        if (dimension == 1) {
            return ModConfig.triggerInEnd;
        }
        if (dimension == -1) {
            return ModConfig.triggerInNether;
        }
        return ModConfig.dimensionBlacklistIsWhitelist == dimensionBlacklist.contains(dimension);
    }

    @Config(modid="forgivingvoid")
    public static class ModConfig {
        @Config.Comment(value={"The y level at which Forgiving Void should forgive the player and send them towards the sky."})
        @Config.RangeInt(min=-64, max=0)
        public static int triggerAtY = -32;
        @Config.Comment(value={"The amount of damage applied to the player when they land."})
        @Config.RangeInt(min=0, max=20)
        public static int damageOnFall = 19;
        @Config.Comment(value={"Prevent death on void fall (limits damage to leave at least 0.5 hearts)"})
        public static boolean preventDeath = false;
        @Config.Comment(value={"The height from which the player will be falling after falling through the void."})
        @Config.RangeInt(min=256, max=4096)
        public static int fallingHeight = 300;
        @Config.Comment(value={"Set to false to make Forgiving Void not trigger in the overworld void (dimension 0)."})
        public static boolean triggerInOverworld = true;
        @Config.Comment(value={"Set to false to make Forgiving Void not trigger in the nether void (dimension -1)."})
        public static boolean triggerInNether = true;
        @Config.Comment(value={"Set to false to make Forgiving Void not trigger in the end void (dimension 1)."})
        public static boolean triggerInEnd = true;
        @Config.Comment(value={"List of additional dimension ids to be blacklisted from Forgiving Void. Options triggerInOverworld etc. take priority."})
        public static String[] dimensionBlacklist = new String[0];
        @Config.Comment(value={"Set to true if you want the dimensionBlacklist to be treated as a whitelist instead. Options triggerInOverworld etc. still take priority."})
        public static boolean dimensionBlacklistIsWhitelist = false;
        @Config.Comment(value={"Set to true if players are rubber-banding while falling through the void. If you're hosting a public server, you should only do this if you have proper anti-cheat installed."})
        public static boolean disableVanillaAntiCheatWhileFalling = true;
    }
}

