/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="forgivingvoid", name="Forgiving Void", acceptedMinecraftVersions="[1.11.2]")
@Mod.EventBusSubscriber
public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.player.field_70163_u < 0.0) {
            event.player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 3));
            event.player.func_70634_a(event.player.field_70165_t, (double)ModConfig.fallingHeight, event.player.field_70161_v);
            event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", true);
        }
    }

    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getEntity().getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
            float damage = ModConfig.damageOnFall;
            if (ModConfig.preventDeath && event.getEntityLiving().func_110143_aJ() - damage <= 0.0f) {
                damage = event.getEntityLiving().func_110143_aJ() - 1.0f;
            }
            event.getEntity().func_70097_a(DamageSource.field_76379_h, damage);
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
            event.getEntity().getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
        }
    }

    @Config(modid="forgivingvoid")
    public static class ModConfig {
        @Config.Comment(value={"The amount of damage applied to the player when they land."})
        @Config.RangeInt(min=0, max=20)
        public static int damageOnFall = 19;
        @Config.Comment(value={"Prevent death on void fall (limits damage to leave at least 0.5 hearts)"})
        public static boolean preventDeath = false;
        @Config.Comment(value={"The height from which the player will be falling after falling through the void."})
        @Config.RangeInt(min=256, max=4096)
        public static int fallingHeight = 300;
    }
}

