/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.List;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidEvent;
import net.blay09.mods.forgivingvoid.compat.GameStagesCompat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="forgivingvoid")
@Mod.EventBusSubscriber
public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    public ForgivingVoid() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ForgivingVoidConfig.commonSpec);
    }

    public void setup(FMLCommonSetupEvent event) {
        ModList.get().getModObjectById("gamestages").ifPresent(it -> new GameStagesCompat());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            if (ForgivingVoid.isEnabledForDimension(event.player.field_71093_bK.func_186068_a()) && event.player.field_70163_u < (double)((Integer)ForgivingVoidConfig.COMMON.triggerAtY.get()).intValue() && ForgivingVoid.fireForgivingVoidEvent(event.player)) {
                event.player.func_195064_c(new PotionEffect(MobEffects.field_76440_q, 60, 3));
                if (event.player.func_184207_aI()) {
                    event.player.func_184226_ay();
                }
                if (event.player.func_184187_bx() != null) {
                    event.player.func_184210_p();
                }
                ((EntityPlayerMP)event.player).field_184851_cj = true;
                event.player.func_70634_a(event.player.field_70165_t, (double)((Integer)ForgivingVoidConfig.COMMON.fallingHeight.get()).intValue(), event.player.field_70161_v);
                event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", true);
            } else if (event.player.getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
                if (event.player.func_70090_H()) {
                    event.player.getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
                    ((EntityPlayerMP)event.player).field_184851_cj = false;
                    return;
                }
                if (((Boolean)ForgivingVoidConfig.COMMON.disableVanillaAntiCheatWhileFalling.get()).booleanValue()) {
                    ((EntityPlayerMP)event.player).field_184851_cj = true;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && event.getEntity().getEntityData().func_74767_n("ForgivingVoidNoFallDamage")) {
            if (((Boolean)ForgivingVoidConfig.COMMON.disableVanillaAntiCheatWhileFalling.get()).booleanValue()) {
                ((EntityPlayerMP)event.getEntity()).field_184851_cj = false;
            }
            if (!event.isCanceled()) {
                float finalDamage;
                float damage = ((Integer)ForgivingVoidConfig.COMMON.damageOnFall.get()).intValue();
                if (((Boolean)ForgivingVoidConfig.COMMON.preventDeath.get()).booleanValue() && event.getEntityLiving().func_110143_aJ() - damage <= 0.0f) {
                    damage = event.getEntityLiving().func_110143_aJ() - 1.0f;
                }
                if ((finalDamage = damage * Math.max(1.0f, event.getDamageMultiplier())) > 0.0f) {
                    event.getEntity().func_70097_a(DamageSource.field_76379_h, finalDamage);
                }
            }
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
            event.getEntity().getEntityData().func_74757_a("ForgivingVoidNoFallDamage", false);
        }
    }

    private static boolean fireForgivingVoidEvent(EntityPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new ForgivingVoidEvent(player));
    }

    private static boolean isEnabledForDimension(int dimension) {
        if (dimension == 0) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInOverworld.get();
        }
        if (dimension == 1) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInEnd.get();
        }
        if (dimension == -1) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInNether.get();
        }
        return ((Boolean)ForgivingVoidConfig.COMMON.dimensionBlacklistIsWhitelist.get()).booleanValue() == ((List)ForgivingVoidConfig.COMMON.dimensionBlacklist.get()).contains(dimension);
    }
}

