/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import net.darkhax.friendlyfire.Configuration;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod(value="friendlyfire")
public class FriendlyFire {
    private Configuration configuration = new Configuration();

    public FriendlyFire() {
        MinecraftForge.EVENT_BUS.addListener(this::onEntityHurt);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, this.configuration.getSpec());
    }

    private void onEntityHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() != null && event.getSource() != null && event.getSource().func_76346_g() != null) {
            LivingEntity living = event.getEntityLiving();
            Entity source = event.getSource().func_76346_g();
            if (living instanceof TameableEntity) {
                boolean sameOwner;
                if (this.configuration.shouldProtectPetsFromOwners()) {
                    LivingEntity owner = ((TameableEntity)living).func_70902_q();
                    if (owner != null && owner.func_110124_au().equals(source.func_110124_au()) && !source.func_70093_af()) {
                        if (this.configuration.shouldReflectDamage()) {
                            owner.func_70097_a(DamageSource.field_76377_j, event.getAmount());
                        }
                        event.setCanceled(true);
                        event.setAmount(0.0f);
                        return;
                    }
                } else if (this.configuration.shouldProtectPetsFromPets() && source instanceof TameableEntity && (sameOwner = ((TameableEntity)living).func_184753_b().equals(((TameableEntity)source).func_184753_b()))) {
                    living.func_70604_c(null);
                    ((LivingEntity)source).func_70604_c(null);
                    event.setCanceled(true);
                    event.setAmount(0.0f);
                    return;
                }
            }
            if (this.configuration.shouldProtectChildren() && living instanceof AgeableEntity && ((AgeableEntity)living).func_70631_g_() && !source.func_70093_af()) {
                event.setCanceled(true);
                event.setAmount(0.0f);
            }
        }
    }
}

