/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.friendlyfire;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue protectPetsFromOwner;
    private final ForgeConfigSpec.BooleanValue protectPetsFromPets;
    private final ForgeConfigSpec.BooleanValue protectChildren;
    private final ForgeConfigSpec.BooleanValue reflectDamage;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("Should pets be protected from damage dealt by their owners?");
        this.protectPetsFromOwner = builder.define("protectPetsFromOwner", true);
        builder.comment("Should pets be protected from damage dealt by other pets with the same owner?");
        this.protectPetsFromPets = builder.define("protectPetsFromOtherPets", true);
        builder.comment("Should children mobs be protected from damage?");
        this.protectChildren = builder.define("protectChildren", true);
        builder.comment("Should damage against friendly mobs be reflected back on the damage dealer?");
        this.reflectDamage = builder.define("reflectDamage", false);
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean shouldProtectPetsFromOwners() {
        return (Boolean)this.protectPetsFromOwner.get();
    }

    public boolean shouldProtectPetsFromPets() {
        return (Boolean)this.protectPetsFromPets.get();
    }

    public boolean shouldProtectChildren() {
        return (Boolean)this.protectChildren.get();
    }

    public boolean shouldReflectDamage() {
        return (Boolean)this.reflectDamage.get();
    }
}

