/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle.items;

import com.flemmli97.mobbattle.CommonProxy;
import com.flemmli97.mobbattle.MobBattle;
import com.flemmli97.mobbattle.items.entitymanager.Team;
import java.util.List;
import javax.annotation.Nullable;
import mca.entity.EntityVillagerMCA;
import mca.enums.EnumGender;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemExtendedSpawnEgg
extends Item {
    public static final String tagString = "mobbattle:Entity";

    public ItemExtendedSpawnEgg() {
        this.func_77655_b("egg_ex");
        this.func_77637_a(MobBattle.customTab);
        this.setRegistryName(new ResourceLocation("mobbattle", "egg_ex"));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        NBTTagCompound compound;
        String entity;
        list.add(TextFormatting.AQUA + "Left click an entity to save it. Shift while doing saves nbt too.");
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack) && (entity = EntityList.func_191302_a((ResourceLocation)new ResourceLocation((compound = stack.func_77978_p().func_74775_l(tagString)).func_74779_i("id")))) != null) {
            String entityName = compound.func_74764_b("CustomName") ? compound.func_74779_i("CustomName") : I18n.func_135052_a((String)("entity." + entity + ".name"), (Object[])new Object[0]);
            list.add(TextFormatting.GOLD + "Spawns " + entityName + (compound.func_186856_d() > 1 ? " (+NBT)" : ""));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityLiving) {
            if (player.field_71075_bZ.field_75098_d) {
                EntityLiving e = (EntityLiving)entity;
                boolean nbt = false;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound == null) {
                    compound = new NBTTagCompound();
                }
                NBTTagCompound tag = new NBTTagCompound();
                if (player.func_70093_af()) {
                    e.func_184198_c(tag);
                    this.removeMobSpecifigTags(tag);
                    nbt = true;
                } else {
                    ResourceLocation name = EntityList.func_191301_a((Entity)e);
                    if (name != null) {
                        tag.func_74778_a("id", name.toString());
                    }
                    if (CommonProxy.mca && e instanceof EntityVillagerMCA) {
                        tag.func_74768_a("MCAGender", ((EntityVillagerMCA)e).attributes.getGender().getId());
                    }
                }
                compound.func_74782_a(tagString, (NBTBase)tag);
                stack.func_77982_d(compound);
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Saved Entity" + (nbt ? " + nbt" : "")));
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.DARK_RED + "Needs to be in creative mode to copy entity"));
            }
        }
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(world, blockpos);
        Entity entity = ItemExtendedSpawnEgg.spawnEntity(world, itemstack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            ItemExtendedSpawnEgg.applyEntityNBT(entity, itemstack);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K || !itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b(tagString)) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(world, player, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = ItemExtendedSpawnEgg.spawnEntity(world, itemstack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity == null) {
                    return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                ItemExtendedSpawnEgg.applyEntityNBT(entity, itemstack);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public static Entity spawnEntity(World world, ItemStack stack, double x, double y, double z) {
        Entity entity = null;
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack) && (entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(stack.func_77978_p().func_74775_l(tagString).func_74779_i("id")), (World)world)) instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (CommonProxy.mca && entityliving instanceof EntityVillagerMCA && stack.func_77978_p().func_74775_l(tagString).func_74764_b("MCAGender")) {
                EntityVillagerMCA villager = (EntityVillagerMCA)entityliving;
                villager.attributes.setGender(EnumGender.byId((int)stack.func_77978_p().func_74775_l(tagString).func_74762_e("MCAGender")));
                villager.attributes.assignRandomName();
                villager.attributes.assignRandomProfession();
                villager.attributes.assignRandomPersonality();
                villager.attributes.assignRandomSkin();
            }
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    private static boolean hasSavedEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(tagString) && stack.func_77978_p().func_74775_l(tagString).func_74764_b("id");
    }

    public static void applyEntityNBT(Entity e, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(tagString)) {
            NBTTagCompound compound = stack.func_77978_p().func_74775_l(tagString);
            NBTTagCompound nbt = e.func_189511_e(new NBTTagCompound());
            nbt.func_179237_a(compound);
            e.func_70020_e(nbt);
        }
        if (stack.func_82837_s() && e instanceof EntityCreature) {
            Team.updateEntity(stack.func_82833_r(), (EntityCreature)e);
        }
    }

    private void removeMobSpecifigTags(NBTTagCompound compound) {
        compound.func_82580_o("Pos");
        compound.func_82580_o("Motion");
        compound.func_82580_o("Rotation");
        compound.func_82580_o("UUIDMost");
        compound.func_82580_o("UUIDLeast");
        compound.func_82580_o("VFAABB");
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            String s = stack.func_77978_p().func_74775_l(tagString).func_74779_i("id");
            ResourceLocation resourcelocation = new ResourceLocation(s);
            if (!s.contains(":")) {
                stack.func_77978_p().func_74775_l(tagString).func_74778_a("id", resourcelocation.toString());
            }
            return resourcelocation;
        }
        return null;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemExtendedSpawnEgg.hasSavedEntity(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(Items.field_151063_bx.getRegistryName(), "inventory"));
    }
}

