/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle.items;

import com.flemmli97.mobbattle.MobBattle;
import com.flemmli97.mobbattle.items.entitymanager.Team;
import com.google.common.base.Functions;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ItemExtendedSpawnEgg
extends Item {
    public static final String tagString = "mobbattle:Entity";

    public ItemExtendedSpawnEgg() {
        super(new Item.Properties().func_200916_a(MobBattle.customTab));
        this.setRegistryName(new ResourceLocation("mobbattle", "egg_ex"));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> list, ITooltipFlag flagIn) {
        list.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + "Left click an entity to save it. Shift while doing saves nbt too."));
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            String entity;
            CompoundNBT compound = stack.func_77978_p().func_74775_l(tagString);
            String string = entity = EntityType.func_220327_a((String)compound.func_74779_i("id")).isPresent() ? ((EntityType)EntityType.func_220327_a((String)compound.func_74779_i("id")).get()).func_210760_d() : "";
            if (entity != null) {
                String entityName = compound.func_74764_b("CustomName") ? compound.func_74779_i("CustomName") : I18n.func_135052_a((String)entity, (Object[])new Object[0]);
                list.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Spawns " + entityName + (compound.func_186856_d() > 1 ? " (+NBT)" : "")));
            }
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (entity instanceof MobEntity) {
            if (player.field_71075_bZ.field_75098_d) {
                MobEntity e = (MobEntity)entity;
                boolean nbt = false;
                CompoundNBT compound = stack.func_77978_p();
                if (compound == null) {
                    compound = new CompoundNBT();
                }
                CompoundNBT tag = new CompoundNBT();
                if (player.func_70093_af()) {
                    e.func_70039_c(tag);
                    this.removeMobSpecifigTags(tag);
                    nbt = true;
                } else {
                    String name = e.func_70022_Q();
                    if (name != null) {
                        tag.func_74778_a("id", name);
                    }
                }
                compound.func_218657_a(tagString, (INBT)tag);
                stack.func_77982_d(compound);
                if (!player.field_70170_p.field_72995_K) {
                    player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + "Saved Entity" + (nbt ? " + nbt" : "")));
                }
            } else {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.DARK_RED + "Needs to be in creative mode to copy entity"));
            }
        }
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        if (ctx.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = ctx.func_195996_i();
        if (!ctx.func_195999_j().func_175151_a(ctx.func_195995_a().func_177972_a(ctx.func_196000_l()), ctx.func_196000_l(), itemstack)) {
            return ActionResultType.FAIL;
        }
        BlockState iblockstate = ctx.func_195991_k().func_180495_p(ctx.func_195995_a());
        BlockPos blockpos = iblockstate.func_196952_d((IBlockReader)ctx.func_195991_k(), ctx.func_195995_a()).func_197766_b() ? ctx.func_195995_a() : ctx.func_195995_a().func_177972_a(ctx.func_196000_l());
        Entity entity = ItemExtendedSpawnEgg.spawnEntity(ctx.func_195991_k(), itemstack, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
        if (entity != null) {
            if (!ctx.func_195999_j().field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (itemstack.func_82837_s() && entity instanceof CreatureEntity) {
                Team.updateEntity(itemstack.func_200301_q().func_150261_e(), (CreatureEntity)entity);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K || !itemstack.func_77942_o() || !itemstack.func_77978_p().func_74764_b(tagString)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        RayTraceResult res = ItemExtendedSpawnEgg.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY);
        if (res != null && res.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult raytraceresult = (BlockRayTraceResult)res;
            BlockPos blockpos = raytraceresult.func_216350_a();
            if (!(world.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
                return new ActionResult(ActionResultType.PASS, (Object)itemstack);
            }
            if (world.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, raytraceresult.func_216354_b(), itemstack)) {
                Entity entity = ItemExtendedSpawnEgg.spawnEntity(world, itemstack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity != null) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    if (itemstack.func_82837_s() && entity instanceof CreatureEntity) {
                        Team.updateEntity(itemstack.func_200301_q().func_150261_e(), (CreatureEntity)entity);
                    }
                    return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
                }
            } else {
                return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)itemstack);
    }

    public static Entity spawnEntity(World world, ItemStack stack, double x, double y, double z) {
        Entity entity = null;
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack) && (entity = EntityType.func_220335_a((CompoundNBT)stack.func_77978_p().func_74775_l(tagString), (World)world, (Function)Functions.identity())) instanceof MobEntity) {
            MobEntity entityliving = (MobEntity)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_213386_a((IWorld)world, world.func_175649_E(new BlockPos((Entity)entityliving)), SpawnReason.SPAWN_EGG, null, null);
            world.func_217376_c(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    private static boolean hasSavedEntity(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(tagString) && stack.func_77978_p().func_74775_l(tagString).func_74764_b("id");
    }

    private void removeMobSpecifigTags(CompoundNBT compound) {
        compound.func_82580_o("Pos");
        compound.func_82580_o("Motion");
        compound.func_82580_o("Rotation");
        compound.func_82580_o("UUIDMost");
        compound.func_82580_o("UUIDLeast");
        compound.func_82580_o("VFAABB");
    }

    @Nullable
    public static ResourceLocation getNamedIdFrom(ItemStack stack) {
        if (ItemExtendedSpawnEgg.hasSavedEntity(stack)) {
            String s = stack.func_77978_p().func_74775_l(tagString).func_74779_i("id");
            ResourceLocation resourcelocation = new ResourceLocation(s);
            if (!s.contains(":")) {
                stack.func_77978_p().func_74775_l(tagString).func_74778_a("id", resourcelocation.toString());
            }
            return resourcelocation;
        }
        return null;
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemExtendedSpawnEgg.hasSavedEntity(stack);
    }
}

