/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle.items.entitymanager;

import com.flemmli97.mobbattle.items.entitymanager.EntityAITeamTarget;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class Team {
    public static Map<TextFormatting, RedstoneParticleData> teamColor = Maps.newHashMap();
    private static final Predicate<Goal> targetGoal;
    private static final Field goalSelector_goal;

    public static String getTeam(Entity entity) {
        return entity.func_96124_cp() != null ? entity.func_96124_cp().func_96661_b() : "none";
    }

    public static boolean isOnSameTeam(Entity entity, Entity entity2) {
        if (entity.func_96124_cp() == null) {
            return true;
        }
        if (entity2.func_96124_cp() == null) {
            return true;
        }
        return entity.func_184191_r(entity2);
    }

    public static void addEntityToTeam(Entity entity, String team) {
        Scoreboard score = entity.field_70170_p.func_96441_U();
        ScorePlayerTeam scoreTeam = score.func_96508_e(team);
        if (scoreTeam == null) {
            scoreTeam = score.func_96527_f(team);
            scoreTeam.func_186682_a(Team.CollisionRule.PUSH_OTHER_TEAMS);
        }
        score.func_96508_e(team).func_96670_d().size();
        score.func_197901_a(entity.func_189512_bd(), scoreTeam);
    }

    public static int getTeamSize(Entity entity, String team) {
        return entity.field_70170_p.func_96441_U().func_96508_e(team) != null ? entity.field_70170_p.func_96441_U().func_96508_e(team).func_96670_d().size() : 0;
    }

    public static void updateEntity(String team, CreatureEntity e) {
        Team.addEntityToTeam((Entity)e, team);
        Team.removeGoal(e.field_70715_bh, targetGoal);
        e.func_70624_b(null);
        e.field_70715_bh.func_75776_a(1, (Goal)new EntityAITeamTarget(e, false, true));
        e.func_184211_a("mobbattle:AddedAI");
    }

    private static void removeGoal(GoalSelector goalSel, Predicate<Goal> pred) {
        try {
            Set goals = (Set)goalSelector_goal.get(goalSel);
            goals.stream().filter(prioGoal -> pred.test(prioGoal.func_220772_j())).filter(PrioritizedGoal::func_220773_g).forEach(PrioritizedGoal::func_75251_c);
            goals.removeIf(prioGoal -> pred.test(prioGoal.func_220772_j()));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static AxisAlignedBB getBoundingBoxPositions(BlockPos pos, @Nullable BlockPos pos2) {
        if (pos2 == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos);
        }
        int xDiff = pos.func_177958_n() - pos2.func_177958_n();
        int yDiff = pos.func_177956_o() - pos2.func_177956_o();
        int zDiff = pos.func_177952_p() - pos2.func_177952_p();
        int z2 = 0;
        int y2 = 0;
        int x2 = 0;
        int z = 0;
        int y = 0;
        int x = 0;
        if (xDiff <= 0) {
            x = 1;
        } else {
            x2 = 1;
        }
        if (yDiff <= 0) {
            y = 1;
        } else {
            y2 = 1;
        }
        if (zDiff <= 0) {
            z = 1;
        } else {
            z2 = 1;
        }
        AxisAlignedBB bb = new AxisAlignedBB((double)(0 + x), (double)(0 + y), (double)(0 + z), (double)(xDiff + x2), (double)(yDiff + y2), (double)(zDiff + z2)).func_186670_a(pos2);
        return bb;
    }

    public static MobEntity fromUUID(ServerWorld world, String uuid) {
        Entity e;
        if (uuid != null && (e = world.func_217461_a(UUID.fromString(uuid))) instanceof MobEntity) {
            return (MobEntity)e;
        }
        return null;
    }

    public static RayTraceResult rayTrace(World worldIn, PlayerEntity playerIn, RayTraceContext.FluidMode fluidmode) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        RayTraceContext ctx = new RayTraceContext(vec3d1, vec3d1, RayTraceContext.BlockMode.OUTLINE, fluidmode, (Entity)playerIn);
        return worldIn.func_217299_a(ctx);
    }

    static {
        teamColor.put(TextFormatting.AQUA, new RedstoneParticleData(0.01f, 0.9f, 1.0f, 1.0f));
        teamColor.put(TextFormatting.BLACK, new RedstoneParticleData(0.01f, 0.0f, 0.0f, 1.0f));
        teamColor.put(TextFormatting.BLUE, new RedstoneParticleData(0.2f, 0.2f, 1.0f, 1.0f));
        teamColor.put(TextFormatting.DARK_AQUA, new RedstoneParticleData(0.01f, 0.4f, 0.5f, 1.0f));
        teamColor.put(TextFormatting.DARK_BLUE, new RedstoneParticleData(0.01f, 0.0f, 0.4f, 1.0f));
        teamColor.put(TextFormatting.DARK_GRAY, new RedstoneParticleData(0.2f, 0.2f, 0.2f, 1.0f));
        teamColor.put(TextFormatting.DARK_GREEN, new RedstoneParticleData(0.01f, 0.5f, 0.0f, 1.0f));
        teamColor.put(TextFormatting.DARK_PURPLE, new RedstoneParticleData(0.3f, 0.0f, 0.4f, 1.0f));
        teamColor.put(TextFormatting.DARK_RED, new RedstoneParticleData(0.5f, 0.0f, 0.0f, 1.0f));
        teamColor.put(TextFormatting.GOLD, new RedstoneParticleData(1.0f, 0.6f, 0.0f, 1.0f));
        teamColor.put(TextFormatting.GRAY, new RedstoneParticleData(0.4f, 0.4f, 0.4f, 1.0f));
        teamColor.put(TextFormatting.GREEN, new RedstoneParticleData(0.01f, 1.0f, 0.0f, 1.0f));
        teamColor.put(TextFormatting.LIGHT_PURPLE, new RedstoneParticleData(0.6f, 0.0f, 0.7f, 1.0f));
        teamColor.put(TextFormatting.RED, new RedstoneParticleData(1.0f, 0.2f, 0.2f, 1.0f));
        teamColor.put(TextFormatting.WHITE, new RedstoneParticleData(1.0f, 1.0f, 1.0f, 1.0f));
        teamColor.put(TextFormatting.YELLOW, new RedstoneParticleData(1.0f, 1.0f, 0.0f, 1.0f));
        targetGoal = goal -> goal instanceof TargetGoal;
        goalSelector_goal = ObfuscationReflectionHelper.findField(GoalSelector.class, (String)"field_220892_d");
    }
}

