/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle.network;

import com.flemmli97.mobbattle.MobBattle;
import com.flemmli97.mobbattle.ModItems;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class EquipMessage {
    public ItemStack equipment;
    public int entityId;
    public int slot;

    public EquipMessage(ItemStack stack, int entityId, int slot) {
        this.equipment = stack;
        this.entityId = entityId;
        this.slot = slot;
    }

    public static EquipMessage fromBytes(PacketBuffer buf) {
        CompoundNBT compound = buf.func_150793_b();
        return new EquipMessage(compound.func_74764_b("Stack") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("Stack")) : ItemStack.field_190927_a, compound.func_74762_e("EntityID"), compound.func_74762_e("Slot"));
    }

    public static void toBytes(EquipMessage msg, PacketBuffer buf) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT tag = new CompoundNBT();
        compound.func_74768_a("EntityID", msg.entityId);
        if (msg.equipment != null) {
            compound.func_218657_a("Stack", (INBT)msg.equipment.func_77955_b(tag));
        }
        compound.func_74768_a("Slot", msg.slot);
        buf.func_150786_a(compound);
    }

    public static void onMessage(EquipMessage msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getSender() == null || ctx.get().getSender().func_184614_ca().func_77973_b() != ModItems.mobArmor) {
            return;
        }
        ctx.get().enqueueWork(() -> {
            World world = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p;
            Entity e = world.func_73045_a(msg.entityId);
            if (e instanceof MobEntity) {
                e.func_184201_a(MobBattle.slot[msg.slot], msg.equipment);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

