/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle.items.entitymanager;

import com.flemmli97.mobbattle.items.entitymanager.EntityAITeamTarget;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.StatList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class Team {
    public static Map<TextFormatting, double[]> teamColor = Maps.newHashMap();

    public static String getTeam(Entity entity) {
        return entity.func_96124_cp() != null ? entity.func_96124_cp().func_96661_b() : "none";
    }

    public static boolean isOnSameTeam(Entity entity, Entity entity2) {
        if (entity.func_96124_cp() == null) {
            return true;
        }
        if (entity2.func_96124_cp() == null) {
            return true;
        }
        return entity.func_184191_r(entity2);
    }

    public static void addEntityToTeam(Entity entity, String team) {
        Scoreboard score = entity.field_70170_p.func_96441_U();
        if (score.func_96508_e(team) == null) {
            score.func_96527_f(team);
            score.func_96508_e(team).func_186682_a(Team.CollisionRule.HIDE_FOR_OTHER_TEAMS);
        }
        score.func_151392_a(entity.func_189512_bd(), team);
    }

    public static void updateEntity(String team, EntityCreature e) {
        Team.addEntityToTeam((Entity)e, team);
        e.field_70715_bh.field_75782_a.removeIf(new Predicate<EntityAITasks.EntityAITaskEntry>(){

            @Override
            public boolean test(EntityAITasks.EntityAITaskEntry input) {
                return input.field_75733_a instanceof EntityAITarget;
            }
        });
        e.func_70624_b(null);
        e.func_70606_j(e.func_110138_aP());
        e.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITeamTarget(e, false, true));
    }

    public static AxisAlignedBB getBoundingBoxPositions(BlockPos pos, @Nullable BlockPos pos2) {
        if (pos2 == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(pos);
        }
        int xDiff = pos.func_177958_n() - pos2.func_177958_n();
        int yDiff = pos.func_177956_o() - pos2.func_177956_o();
        int zDiff = pos.func_177952_p() - pos2.func_177952_p();
        int z2 = 0;
        int y2 = 0;
        int x2 = 0;
        int z = 0;
        int y = 0;
        int x = 0;
        if (xDiff <= 0) {
            x = 1;
        } else {
            x2 = 1;
        }
        if (yDiff <= 0) {
            y = 1;
        } else {
            y2 = 1;
        }
        if (zDiff <= 0) {
            z = 1;
        } else {
            z2 = 1;
        }
        AxisAlignedBB bb = new AxisAlignedBB((double)(0 + x), (double)(0 + y), (double)(0 + z), (double)(xDiff + x2), (double)(yDiff + y2), (double)(zDiff + z2)).func_186670_a(pos2);
        return bb;
    }

    public static EntityLiving fromUUID(World world, String uuid) {
        if (uuid != null) {
            for (Entity entity : world.field_72996_f) {
                if (entity.func_189512_bd() != uuid || !(entity instanceof EntityLiving)) continue;
                return (EntityLiving)entity;
            }
        }
        return null;
    }

    public static double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72314_b(0.0, -1.0, 0.0);
        List list = world.func_184144_a((Entity)null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public static RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = 5.0;
        if (playerIn instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)playerIn).field_71134_c.getBlockReachDistance();
        }
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }

    public static void applyTeamModSpawnEgg(EntityPlayer player, ItemStack stack) {
        RayTraceResult raytraceresult = Team.rayTrace(player.field_70170_p, player, true);
        if (raytraceresult != null && raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            Entity entity;
            BlockPos blockpos = raytraceresult.func_178782_a();
            boolean liquid = player.field_70170_p.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid;
            if (!liquid) {
                blockpos = blockpos.func_177972_a(raytraceresult.field_178784_b);
                blockpos = new BlockPos((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o() + Team.getYOffset(player.field_70170_p, blockpos), (double)blockpos.func_177952_p());
            }
            if (player.field_70170_p.func_175660_a(player, blockpos) && player.func_175151_a(blockpos, raytraceresult.field_178784_b, stack) && (entity = ItemMonsterPlacer.func_77840_a((World)player.field_70170_p, (String)ItemMonsterPlacer.func_185080_h((ItemStack)stack), (double)((double)blockpos.func_177958_n() + (liquid ? 0.5 : 0.0)), (double)((double)blockpos.func_177956_o() + 0.5), (double)((double)blockpos.func_177952_p() + 0.5))) != null) {
                ItemMonsterPlacer.func_185079_a((World)player.field_70170_p, (EntityPlayer)player, (ItemStack)stack, (Entity)entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                player.func_71029_a(StatList.func_188057_b((Item)stack.func_77973_b()));
                if (entity instanceof EntityCreature && stack.func_82833_r().equals("BLUE") || stack.func_82833_r().equals("RED")) {
                    Team.updateEntity(stack.func_82833_r(), (EntityCreature)entity);
                }
            }
        }
    }

    static {
        teamColor.put(TextFormatting.AQUA, new double[]{0.01, 0.9, 1.0});
        teamColor.put(TextFormatting.BLACK, new double[]{0.01, 0.0, 0.0});
        teamColor.put(TextFormatting.BLUE, new double[]{0.2, 0.2, 1.0});
        teamColor.put(TextFormatting.DARK_AQUA, new double[]{0.01, 0.4, 0.5});
        teamColor.put(TextFormatting.DARK_BLUE, new double[]{0.01, 0.0, 0.4});
        teamColor.put(TextFormatting.DARK_GRAY, new double[]{0.2, 0.2, 0.2});
        teamColor.put(TextFormatting.DARK_GREEN, new double[]{0.01, 0.5, 0.0});
        teamColor.put(TextFormatting.DARK_PURPLE, new double[]{0.3, 0.0, 0.4});
        teamColor.put(TextFormatting.DARK_RED, new double[]{0.5, 0.0, 0.0});
        teamColor.put(TextFormatting.GOLD, new double[]{1.0, 0.6, 0.0});
        teamColor.put(TextFormatting.GRAY, new double[]{0.4, 0.4, 0.4});
        teamColor.put(TextFormatting.GREEN, new double[]{0.01, 1.0, 0.0});
        teamColor.put(TextFormatting.LIGHT_PURPLE, new double[]{0.6, 0.0, 0.7});
        teamColor.put(TextFormatting.RED, new double[]{1.0, 0.2, 0.2});
        teamColor.put(TextFormatting.WHITE, new double[]{1.0, 1.0, 1.0});
        teamColor.put(TextFormatting.YELLOW, new double[]{1.0, 1.0, 0.0});
    }
}

