/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.mobbattle;

import com.flemmli97.mobbattle.CommonProxy;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class EquipMessage
implements IMessage {
    public ItemStack equipment;
    public String uuid;
    public int slot;

    public EquipMessage() {
    }

    public EquipMessage(ItemStack stack, String entityUUID, int slot) {
        this.equipment = stack;
        this.uuid = entityUUID;
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.equipment = compound.func_74764_b("Stack") ? new ItemStack((NBTTagCompound)compound.func_74781_a("Stack")) : null;
        this.uuid = compound.func_74779_i("UUID");
        this.slot = compound.func_74762_e("Slot");
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        compound.func_74778_a("UUID", this.uuid);
        if (this.equipment != null) {
            compound.func_74782_a("Stack", (NBTBase)this.equipment.func_77955_b(tag));
        }
        compound.func_74768_a("Slot", this.slot);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)compound);
    }

    public static class Handler
    implements IMessageHandler<EquipMessage, IMessage> {
        public IMessage onMessage(EquipMessage msg, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            for (Object obj : world.field_72996_f) {
                EntityLiving entity;
                if (!(obj instanceof EntityLiving) || !(entity = (EntityLiving)obj).func_110124_au().equals(UUID.fromString(msg.uuid))) continue;
                entity.func_184201_a(CommonProxy.slot[msg.slot], msg.equipment);
            }
            return null;
        }
    }
}

