/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

class CommandTestTemplate {
    public static RuinTemplate parsedRuin;
    public static final LiteralArgumentBuilder<CommandSource> BUILDER;

    CommandTestTemplate() {
    }

    private static void execute(CommandSource source, String input) {
        block11: {
            if (source.func_197022_f() instanceof PlayerEntity) {
                PlayerEntity sender = (PlayerEntity)source.func_197022_f();
                String[] args = input == null ? new String[]{} : input.split(" ");
                RuinsMod.LOGGER.info("called test command with input [{}], args count {}", (Object)input, (Object)args.length);
                int xpos = sender.func_180425_c().func_177958_n();
                int ypos = sender.func_180425_c().func_177956_o();
                int zpos = sender.func_180425_c().func_177952_p();
                if (args.length < 4) {
                    if (args.length < 1) {
                        if (parsedRuin != null) {
                            parsedRuin.doBuild(sender.func_130014_f_(), sender.func_130014_f_().field_73012_v, xpos, ypos, zpos, 0, true, false);
                            parsedRuin = null;
                        } else {
                            sender.func_145747_a((ITextComponent)new TranslationTextComponent("You need to use the command with the target template name, eg. /testruin beach/LightHouse", new Object[0]));
                        }
                    } else {
                        CommandTestTemplate.tryBuild(sender, args, xpos, ypos, zpos, true);
                    }
                } else {
                    try {
                        if (args[2].equals("_")) {
                            int x = Integer.valueOf(args[1]);
                            int z = Integer.valueOf(args[3]);
                            CommandTestTemplate.tryBuild(sender, args, x, -1, z, true);
                            break block11;
                        }
                        int x = Integer.valueOf(args[1]);
                        int y = Integer.valueOf(args[2]);
                        int z = Integer.valueOf(args[3]);
                        CommandTestTemplate.tryBuild(sender, args, x, y, z, true);
                    }
                    catch (NumberFormatException e) {
                        sender.func_145747_a((ITextComponent)new TranslationTextComponent("Invalid coordinates specified", new Object[0]));
                    }
                }
            } else {
                source.func_197021_a((ITextComponent)new TranslationTextComponent("Command is only available for ingame player entities, or with coordinates specified", new Object[0]));
            }
        }
    }

    private static void tryBuild(PlayerEntity sender, String[] args, int x, int y, int z, boolean is_player) {
        block11: {
            File file;
            String target = args[0];
            if (!target.contains("/")) {
                target = "templateparser/" + target;
            }
            if ((file = new File(RuinsMod.getMinecraftBaseDir(), "config/ruins_config/" + target + ".tml")).exists() && file.canWrite()) {
                try {
                    parsedRuin = new RuinTemplate(file.getCanonicalPath(), file.getName(), is_player);
                    int rotation = args.length > 4 ? Integer.parseInt(args[4]) : 0;
                    boolean ignore_ceiling = args.length > 5 && Boolean.parseBoolean(args[5]);
                    World world = sender.func_130014_f_();
                    if (parsedRuin != null) {
                        if (y < 0) {
                            int ceiling = ignore_ceiling ? world.func_217301_I() : world.func_72940_L();
                            for (y = ceiling - 1; y > 7; --y) {
                                BlockPos pos = new BlockPos(x, y, z);
                                BlockState b = world.func_180495_p(pos);
                                if (parsedRuin.isIgnoredBlock(b, world, pos)) continue;
                                if (parsedRuin.isAcceptableSurface(b)) break;
                                sender.func_145747_a((ITextComponent)new TranslationTextComponent("Could not find acceptable Y coordinate", new Object[0]));
                                return;
                            }
                            ++y;
                        }
                        if (parsedRuin.doBuild(world, world.field_73012_v, x, y, z, rotation, is_player, ignore_ceiling) >= 0) {
                            parsedRuin = null;
                        } else {
                            sender.func_145747_a((ITextComponent)new TranslationTextComponent("EventRuinTemplateSpawn returned as cancelled, not building that.", new Object[0]));
                        }
                        break block11;
                    }
                    sender.func_145747_a((ITextComponent)new TranslationTextComponent("Could not parse Ruin of file " + file, new Object[0]));
                }
                catch (RuinTemplate.IncompatibleModException e) {
                    sender.func_145747_a((ITextComponent)new TranslationTextComponent(e.getMessage(), new Object[0]));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                sender.func_145747_a((ITextComponent)new TranslationTextComponent("Could not open/write file " + file, new Object[0]));
            }
        }
    }

    static {
        BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"testruin").requires(caller -> caller.func_197034_c(2))).then(Commands.func_197056_a((String)"input", (ArgumentType)StringArgumentType.greedyString()).executes(caller -> {
            CommandTestTemplate.execute((CommandSource)caller.getSource(), StringArgumentType.getString((CommandContext)caller, (String)"input"));
            return 1;
        }))).executes(caller -> {
            CommandTestTemplate.execute((CommandSource)caller.getSource(), null);
            return 1;
        });
    }
}

