/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinsMod;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ConfigFolderPreparator {
    public static void copyFromJarIfNotPresent(RuinsMod ruinsMod, File targetDir) {
        if (targetDir.exists()) {
            return;
        }
        URL url = ruinsMod.getClass().getClassLoader().getResource("ruins_config");
        try {
            ConfigFolderPreparator.copyJarResourceToFolder((JarURLConnection)url.openConnection(), targetDir);
        }
        catch (Exception e) {
            System.err.println("Ruins couldn't prepare template defaults for some reason:");
            e.printStackTrace();
        }
    }

    private static void copyJarResourceToFolder(JarURLConnection jarConnection, File destDir) {
        try {
            JarFile jarFile = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String jarConnectionEntryName;
                JarEntry jarEntry = e.nextElement();
                String jarEntryName = jarEntry.getName();
                if (!jarEntryName.startsWith(jarConnectionEntryName = jarConnection.getEntryName())) continue;
                String filename = jarEntryName.startsWith(jarConnectionEntryName) ? jarEntryName.substring(jarConnectionEntryName.length()) : jarEntryName;
                File currentFile = new File(destDir, filename);
                if (jarEntry.isDirectory()) {
                    currentFile.mkdirs();
                    continue;
                }
                InputStream is = jarFile.getInputStream(jarEntry);
                FileOutputStream out = FileUtils.openOutputStream((File)currentFile);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

