/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.EventRuinTemplateSpawn;
import atomicstryker.ruins.common.RuinData;
import atomicstryker.ruins.common.RuinTemplate;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommandUndoTemplate {
    private static final ArrayList<TemplateArea> savedLocations = new ArrayList();
    public static final LiteralArgumentBuilder<CommandSource> BUILDER = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"undoruin").requires(caller -> caller.func_197034_c(2))).executes(caller -> {
        CommandUndoTemplate.execute((CommandSource)caller.getSource());
        return 1;
    });
    private static RuinTemplate runningTemplateSpawn;

    public CommandUndoTemplate() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void execute(CommandSource source) {
        ServerWorld w = source.func_197023_e();
        if (savedLocations.isEmpty()) {
            source.func_197021_a((ITextComponent)new TranslationTextComponent("There is nothing cached to be undone...", new Object[0]));
        } else {
            for (TemplateArea ta : savedLocations) {
                for (int x = 0; x < ta.blockArray.length; ++x) {
                    for (int y = 0; y < ta.blockArray[0].length; ++y) {
                        for (int z = 0; z < ta.blockArray[0][0].length; ++z) {
                            w.func_180501_a(new BlockPos(ta.xBase + x, ta.yBase + y, ta.zBase + z), ta.blockArray[x][y][z], 2);
                        }
                    }
                }
                w.func_217357_a(ItemEntity.class, new AxisAlignedBB(new BlockPos(ta.xBase - 1, ta.yBase - 1, ta.zBase - 1), new BlockPos(ta.xBase + ta.blockArray.length + 1, ta.yBase + ta.blockArray[0].length + 1, ta.zBase + ta.blockArray[0][0].length + 1))).forEach(Entity::func_174812_G);
            }
            source.func_197030_a((ITextComponent)new TranslationTextComponent("Cleared away " + savedLocations.size() + " template sites.", new Object[0]), false);
            savedLocations.clear();
        }
    }

    @SubscribeEvent
    public void onSpawningRuin(EventRuinTemplateSpawn event) {
        if (event.testingRuin || runningTemplateSpawn != null) {
            if (event.isPrePhase) {
                if (runningTemplateSpawn == null) {
                    runningTemplateSpawn = event.template;
                    savedLocations.clear();
                } else {
                    System.out.println("Ruins undo command caught adjacent template, saving it too..");
                }
                RuinData data = event.template.getRuinData(event.x, event.y, event.z, event.rotation);
                TemplateArea ta = new TemplateArea();
                ta.xBase = data.xMin;
                ta.yBase = data.yMin;
                ta.zBase = data.zMin;
                ta.blockArray = new BlockState[data.xMax - data.xMin + 1][data.yMax - data.yMin + 1][data.zMax - data.zMin + 1];
                for (int x = 0; x < ta.blockArray.length; ++x) {
                    for (int y = 0; y < ta.blockArray[0].length; ++y) {
                        for (int z = 0; z < ta.blockArray[0][0].length; ++z) {
                            ta.blockArray[x][y][z] = event.getWorld().func_180495_p(new BlockPos(ta.xBase + x, ta.yBase + y, ta.zBase + z));
                        }
                    }
                }
                savedLocations.add(ta);
                if (savedLocations.size() > 100) {
                    savedLocations.clear();
                    runningTemplateSpawn = null;
                }
            } else if (runningTemplateSpawn == event.template) {
                runningTemplateSpawn = null;
            }
        }
    }

    private class TemplateArea {
        BlockState[][][] blockArray;
        int xBase;
        int yBase;
        int zBase;

        private TemplateArea() {
        }
    }
}

