/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

class FileHandler {
    private static final int WEIGHT = 0;
    private static final int CHANCE = 1;
    private final HashMap<String, HashSet<RuinTemplate>> templates = new HashMap();
    private final DimensionType dimension;
    private final HashMap<String, double[]> vars = new HashMap();
    private static IForgeRegistry<Biome> biomeRegistry = null;
    int triesPerChunkNormal = 6;
    int triesPerChunkNether = 6;
    float chanceToSpawnNormal = 10.0f;
    float chanceToSpawnNether = 10.0f;
    private int[] allowedDimensions = new int[]{-1, 0, 1};
    public boolean loaded;
    boolean disableLogging = true;
    final File saveFolder;
    public float templateInstancesMinDistance = 256.0f;
    float anyRuinsMinDistance = 64.0f;
    public int anySpawnMinDistance = 32;
    public int anySpawnMaxDistance = Integer.MAX_VALUE;
    public boolean enableStick = true;
    public static boolean enableFixedWidthRuleIds = false;
    private int templateCount;
    private static final Pattern patternSpecificBiome = Pattern.compile("specific_([^=]++)=(.++)");

    public FileHandler(File worldPath, DimensionType dim) {
        this.saveFolder = worldPath;
        this.loaded = false;
        this.templateCount = 0;
        this.dimension = dim;
        new LoaderThread().start();
    }

    private IForgeRegistry<Biome> getBiomeRegistry() {
        if (biomeRegistry == null) {
            biomeRegistry = GameRegistry.findRegistry(Biome.class);
        }
        return biomeRegistry;
    }

    RuinTemplate getTemplate(Random random, String biome) {
        try {
            double rand = random.nextDouble() * this.vars.get(biome)[0];
            RuinTemplate retval = null;
            Iterator<RuinTemplate> iterator = this.templates.get(biome).iterator();
            while (iterator.hasNext()) {
                double d;
                RuinTemplate ruinTemplate;
                retval = ruinTemplate = iterator.next();
                rand -= retval.getWeight();
                if (!(d < 0.0)) continue;
                break;
            }
            return retval;
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean useGeneric(Random random, String biome) {
        double[] val = this.vars.get(biome);
        return "generic".equals(biome) || val != null && random.nextDouble() >= val[1];
    }

    private void loadSpecificTemplates(File dir, String bname) throws Exception {
        File path_biome = new File(dir, bname);
        if (!this.templates.containsKey(bname)) {
            this.templates.put(bname, new HashSet());
        }
        HashSet<RuinTemplate> set = this.templates.get(bname);
        this.addRuins(path_biome, bname, set);
    }

    private void recalcBiomeWeight(String biomeName) {
        Iterator<RuinTemplate> i = this.templates.get(biomeName).iterator();
        double[] val = this.vars.get(biomeName);
        val[0] = 0.0;
        while (i.hasNext()) {
            val[0] = val[0] + i.next().getWeight();
        }
        this.vars.put(biomeName, val);
    }

    private void readPerWorldOptions(File dir) throws Exception {
        File file = new File(dir, "ruins.txt");
        if (!file.exists()) {
            this.copyGlobalOptionsTo(dir);
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String read = br.readLine();
        while (read != null) {
            Matcher matcher = null;
            String[] check = read.split("=");
            if (check[0].equals("tries_per_chunk_normal")) {
                this.triesPerChunkNormal = Integer.parseInt(check[1]);
            } else if (check[0].equals("chance_to_spawn_normal")) {
                this.chanceToSpawnNormal = Float.parseFloat(check[1]);
            } else if (check[0].equals("tries_per_chunk_nether")) {
                this.triesPerChunkNether = Integer.parseInt(check[1]);
            } else if (check[0].equals("chance_to_spawn_nether")) {
                this.chanceToSpawnNether = Float.parseFloat(check[1]);
            } else if (check[0].equals("disableRuinSpawnCoordsLogging")) {
                this.disableLogging = Boolean.parseBoolean(check[1]);
            } else if (check[0].equals("templateInstancesMinDistance")) {
                this.templateInstancesMinDistance = Float.parseFloat(check[1]);
            } else if (check[0].equals("anyRuinsMinDistance")) {
                this.anyRuinsMinDistance = Float.parseFloat(check[1]);
            } else if (check[0].equals("anySpawnMinDistance")) {
                int value = Integer.parseInt(check[1]);
                this.anySpawnMinDistance = value > 0 ? value : 0;
            } else if (check[0].equals("anySpawnMaxDistance")) {
                int value = Integer.parseInt(check[1]);
                this.anySpawnMaxDistance = value > 0 ? value : Integer.MAX_VALUE;
            } else if (check[0].equals("enableStick")) {
                this.enableStick = Boolean.parseBoolean(check[1]);
            } else if (check[0].equals("allowedDimensions") && check.length > 1) {
                String[] ints = check[1].split(",");
                this.allowedDimensions = new int[ints.length];
                for (int i = 0; i < ints.length; ++i) {
                    this.allowedDimensions[i] = Integer.parseInt(ints[i]);
                }
            } else if (this.dimension == DimensionType.field_223228_b_ && check[0].equals("enableFixedWidthRuleIds")) {
                enableFixedWidthRuleIds = Boolean.parseBoolean(check[1]);
            } else {
                matcher = patternSpecificBiome.matcher(read);
                if (matcher.matches()) {
                    boolean found = false;
                    IForgeRegistry<Biome> biomeRegistry = this.getBiomeRegistry();
                    for (ResourceLocation rl : biomeRegistry.getKeys()) {
                        double[] val;
                        Biome bgb = (Biome)biomeRegistry.getValue(rl);
                        if (bgb == null || !bgb.getRegistryName().func_110623_a().equals(matcher.group(1)) || (val = this.vars.get(bgb.getRegistryName().func_110623_a())) == null) continue;
                        val[1] = Math.min(Math.max(Double.parseDouble(matcher.group(2)) / 100.0, 0.0), 1.0);
                        found = true;
                        this.vars.put(bgb.getRegistryName().func_110623_a(), val);
                        break;
                    }
                    if (!found && !this.disableLogging) {
                        System.out.println("Did not find Matching Biome for config string: [" + matcher.group(1) + "]");
                    }
                }
            }
            read = br.readLine();
        }
        br.close();
    }

    private void addRuins(File path, String name, HashSet<RuinTemplate> targetList) {
        File[] listFiles = path.listFiles();
        String dimensionName = DimensionType.func_212678_a((DimensionType)this.dimension).func_110623_a();
        if (listFiles != null) {
            for (File f : listFiles) {
                try {
                    RuinTemplate r = new RuinTemplate(f.getCanonicalPath(), f.getName());
                    if (!r.acceptsDimension(dimensionName)) continue;
                    targetList.add(r);
                    for (String biomeName : r.getBiomesToSpawnIn()) {
                        for (ResourceLocation rl : this.getBiomeRegistry().getKeys()) {
                            Biome bgb = (Biome)this.getBiomeRegistry().getValue(rl);
                            if (bgb == null || !bgb.getRegistryName().func_110623_a().equals(biomeName) || biomeName.equals(name)) continue;
                            if (!this.templates.containsKey(biomeName)) {
                                this.templates.put(biomeName, new HashSet());
                            }
                            this.templates.get(biomeName).add(r);
                        }
                    }
                    ++this.templateCount;
                }
                catch (RuinTemplate.IncompatibleModException e) {
                    RuinsMod.LOGGER.error("IncompatibleModException", (Throwable)e);
                }
                catch (Exception e) {
                    RuinsMod.LOGGER.error("There was a problem loading the file: " + f.getName(), (Throwable)e);
                }
            }
        } else {
            RuinsMod.LOGGER.info("Did not find any Building data for {}, creating empty folder for it: {}", (Object)path, (Object)(path.mkdir() ? "success" : "failed"));
        }
    }

    boolean allowsDimension(int dimensionId) {
        for (int i : this.allowedDimensions) {
            if (i != dimensionId) continue;
            return true;
        }
        return false;
    }

    private void copyGlobalOptionsTo(File dir) throws Exception {
        File copyfile = new File(dir, "ruins.txt");
        if (copyfile.exists()) {
            return;
        }
        File configdir = new File(RuinsMod.getMinecraftBaseDir(), "config");
        File basefile = new File(configdir, "ruins.txt");
        if (!basefile.exists()) {
            this.createDefaultGlobalOptions(configdir);
        }
        Files.copy((File)basefile, (File)copyfile);
    }

    private void createDefaultGlobalOptions(File dir) throws Exception {
        File file = new File(dir, "ruins.txt");
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        pw.println("# Global Options for the Ruins mod");
        pw.println("#");
        pw.println("# tries_per_chunk is the number of times, per chunk, that the generator will");
        pw.println("#     attempt to create a ruin.");
        pw.println("#");
        pw.println("# chance_to_spawn is the chance, out of 100, that a ruin will be generated per");
        pw.println("#     try in this chunk.  This may still fail if the ruin does not have a");
        pw.println("#     suitable place to generate.");
        pw.println("#");
        pw.println("# specific_<biome name> is the chance, out of 100, that a ruin spawning in the");
        pw.println("#     specified biome will be chosen from the biome specific folder.  If not,");
        pw.println("#     it will choose a generic ruin from the folder of the same name.");
        pw.println("#");
        pw.println("tries_per_chunk_normal=6");
        pw.println("chance_to_spawn_normal=10");
        pw.println("tries_per_chunk_nether=6");
        pw.println("chance_to_spawn_nether=10");
        pw.println("#");
        pw.println("# prevent a message from being logged every time a ruin is built");
        pw.println("disableRuinSpawnCoordsLogging=true");
        pw.println("#");
        pw.println("# minimum distance a template must have from instances of itself");
        pw.println("templateInstancesMinDistance=256");
        pw.println("#");
        pw.println("# minimum distance a template must have from any other template");
        pw.println("anyRuinsMinDistance=64");
        pw.println("#");
        pw.println("# min/max distances overworld templates can have from world spawn (0 = no limit)");
        pw.println("anySpawnMinDistance=32");
        pw.println("anySpawnMaxDistance=0");
        pw.println("#");
        pw.println("# allow displaying a block's data by hitting it with a stick");
        pw.println("enableStick=true");
        pw.println("#");
        pw.println("# dimension IDs whitelisted for ruins spawning, add custom dimensions IDs here as needed");
        pw.println("allowedDimensions=0,1,-1");
        pw.println("#");
        pw.println("# make /parseruin rule IDs line up nicely in template files");
        pw.println("# note: overworld (i.e., dimension 0) setting applies to all dimensions");
        pw.println("enableFixedWidthRuleIds=false");
        pw.println("#");
        pw.println("# tileentity blocks, those (nonvanilla)blocks which cannot function without storing their nbt data, full name as stick dictates, seperated by commata");
        pw.println("teblocks=");
        pw.println();
        for (ResourceLocation rl : this.getBiomeRegistry().getKeys()) {
            Biome bgb = (Biome)this.getBiomeRegistry().getValue(rl);
            if (bgb == null) continue;
            pw.println("specific_" + bgb.getRegistryName().func_110623_a() + "=75");
        }
        pw.flush();
        pw.close();
    }

    private class LoaderThread
    extends Thread {
        private LoaderThread() {
        }

        @Override
        public void run() {
            File basedir;
            try {
                basedir = RuinsMod.getMinecraftBaseDir();
            }
            catch (Exception e) {
                System.err.println("Could not access the main Minecraft directory; error: " + e);
                System.err.println("The ruins mod could not be loaded.");
                e.printStackTrace();
                FileHandler.this.loaded = true;
                return;
            }
            try {
                File log = new File(basedir, "logs/ruins_log_dim_" + FileHandler.this.dimension + ".txt");
                if (!(!log.exists() || log.delete() && log.createNewFile())) {
                    throw new RuntimeException("Ruins crashed trying to access file: " + log.getAbsolutePath());
                }
            }
            catch (Exception e) {
                System.err.println("There was an error when creating the log file.");
                System.err.println("The ruins mod could not be loaded.");
                e.printStackTrace();
                FileHandler.this.loaded = true;
                return;
            }
            File templPath = new File(basedir, "config/ruins_config/");
            if (!templPath.exists()) {
                System.out.println("Could not access the resources path for the ruins templates, file doesn't exist!");
                System.err.println("The ruins mod could not be loaded.");
                FileHandler.this.loaded = true;
                return;
            }
            try {
                HashSet set = new HashSet();
                FileHandler.this.templates.put("generic", set);
                FileHandler.this.addRuins(new File(templPath, "generic"), "generic", set);
            }
            catch (Exception e) {
                RuinsMod.LOGGER.error("There was an error when loading the generic ruins templates:", (Throwable)e);
            }
            IForgeRegistry biomeRegistry = FileHandler.this.getBiomeRegistry();
            for (ResourceLocation rl : biomeRegistry.getKeys()) {
                Biome bgb = (Biome)biomeRegistry.getValue(rl);
                if (bgb == null) continue;
                try {
                    FileHandler.this.loadSpecificTemplates(templPath, bgb.getRegistryName().func_110623_a());
                }
                catch (Exception e) {
                    RuinsMod.LOGGER.error("There was an error when loading the {}" + bgb.getRegistryName().func_110623_a() + " ruins templates:", (Throwable)e);
                }
            }
            for (String bname : FileHandler.this.templates.keySet()) {
                double[] val = new double[2];
                FileHandler.this.vars.put(bname, val);
                FileHandler.this.recalcBiomeWeight(bname);
            }
            try {
                RuinsMod.LOGGER.info("Loading options from: {}", (Object)FileHandler.this.saveFolder.getCanonicalPath());
                FileHandler.this.readPerWorldOptions(FileHandler.this.saveFolder);
            }
            catch (Exception e) {
                RuinsMod.LOGGER.error("There was an error when loading the options file.  Defaults will be used instead.", (Throwable)e);
            }
            FileHandler.this.loaded = true;
            RuinsMod.LOGGER.info("Ruins mod loaded successfully for world {} template files: {}", (Object)FileHandler.this.saveFolder, (Object)FileHandler.this.templateCount);
        }
    }
}

