/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.apache.logging.log4j.util.Supplier;

public class RuinTemplateRule {
    private final BlockState[] blockStates;
    private final CompoundNBT[] tileEntityData;
    private final double[] blockWeights;
    private final int[] blockBonemeals;
    private final RuinTemplate owner;
    private final boolean excessiveDebugging;
    private double blockWeightsTotal;
    private static final String PARAMETERS_TAG = "Ruins";
    private static final String NAME_TAG = "Name";
    private static final String NULL_BLOCK_NAME = "ruins:null";
    private static final String PARAMETER_WEIGHT_TAG = "weight";
    private static final String PARAMETER_BONEMEAL_TAG = "bonemeal";
    private static final String PARAMETER_ENTITY_TAG = "entity";

    public RuinTemplateRule(RuinTemplate r, String rule, boolean debug) {
        this.owner = r;
        this.excessiveDebugging = debug;
        List<CompoundNBT> stateCompounds = RuleStringNbtHelper.splitRuleByBrackets(rule);
        if (stateCompounds == null || stateCompounds.isEmpty()) {
            RuinsMod.LOGGER.error("could not find any blockstates in rule {}", (Object)rule);
            this.blockStates = new BlockState[0];
            this.blockWeights = new double[0];
            this.blockBonemeals = new int[0];
            this.tileEntityData = new CompoundNBT[0];
            return;
        }
        int numblocks = stateCompounds.size();
        this.blockStates = new BlockState[numblocks];
        this.blockWeights = new double[numblocks];
        this.blockBonemeals = new int[numblocks];
        this.tileEntityData = new CompoundNBT[numblocks];
        this.blockWeightsTotal = 0.0;
        for (int i = 0; i < numblocks; ++i) {
            CompoundNBT stateCompound = stateCompounds.get(i);
            double blockWeight = 1.0;
            int blockBonemeal = 0;
            CompoundNBT blockEntity = null;
            if (stateCompound.func_150297_b(PARAMETERS_TAG, 10)) {
                CompoundNBT parameters = stateCompound.func_74775_l(PARAMETERS_TAG);
                blockWeight = RuinTemplateRule.extractWeight(blockWeight, parameters);
                blockBonemeal = RuinTemplateRule.extractBonemeal(blockBonemeal, parameters);
                blockEntity = RuinTemplateRule.extractEntity(blockEntity, parameters);
                if (!parameters.isEmpty()) {
                    RuinsMod.LOGGER.warn("ignoring invalid Ruins parameters {} in rule {}", new Supplier[]{() -> parameters.func_150296_c().toString(), () -> rule});
                }
                stateCompound.func_82580_o(PARAMETERS_TAG);
            }
            this.blockWeights[i] = blockWeight;
            this.blockWeightsTotal += this.blockWeights[i];
            this.blockBonemeals[i] = blockBonemeal;
            if (stateCompound.func_74779_i(NAME_TAG).equals(NULL_BLOCK_NAME)) {
                this.blockStates[i] = null;
                this.tileEntityData[i] = null;
                if (!this.excessiveDebugging) continue;
                RuinsMod.LOGGER.info("rule alternative: {}, {}", (Object)(i + 1), (Object)NULL_BLOCK_NAME);
                continue;
            }
            this.blockStates[i] = RuleStringNbtHelper.blockStateFromCompound(stateCompound);
            this.tileEntityData[i] = RuleStringNbtHelper.tileEntityNBTFromCompound(blockEntity, stateCompound);
            if (!this.excessiveDebugging) continue;
            RuinsMod.LOGGER.info("rule alternative: {}, {}", (Object)(i + 1), (Object)this.blockStates[i].toString());
        }
    }

    RuinTemplateRule(RuinTemplate r, String rule) {
        this(r, rule, false);
    }

    private static double extractWeight(double defaultValue, CompoundNBT parameters) {
        double value;
        double weight = defaultValue;
        if (parameters.func_150297_b(PARAMETER_WEIGHT_TAG, 99) && (value = parameters.func_74769_h(PARAMETER_WEIGHT_TAG)) >= 0.0) {
            weight = value;
            parameters.func_82580_o(PARAMETER_WEIGHT_TAG);
        }
        return weight;
    }

    private static int extractBonemeal(int defaultValue, CompoundNBT parameters) {
        int value;
        int bonemeal = defaultValue;
        if (parameters.func_150297_b(PARAMETER_BONEMEAL_TAG, 3) && (value = parameters.func_74762_e(PARAMETER_BONEMEAL_TAG)) >= 0) {
            bonemeal = value;
            parameters.func_82580_o(PARAMETER_BONEMEAL_TAG);
        }
        return bonemeal;
    }

    private static CompoundNBT extractEntity(CompoundNBT defaultValue, CompoundNBT parameters) {
        CompoundNBT entity = defaultValue;
        if (parameters.func_150297_b(PARAMETER_ENTITY_TAG, 10)) {
            entity = parameters.func_74775_l(PARAMETER_ENTITY_TAG).func_74737_b();
            entity.func_82580_o("id");
            entity.func_82580_o("x");
            entity.func_82580_o("y");
            entity.func_82580_o("z");
            parameters.func_82580_o(PARAMETER_ENTITY_TAG);
        }
        return entity;
    }

    private static Rotation getDirectionalRotation(int direction) {
        Rotation rotation = Rotation.NONE;
        switch (direction) {
            case 1: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
            case 2: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 3: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return rotation;
    }

    public void doBlock(World world, Random random, BlockPos pos, int rotate) {
        int blocknum = this.getBlockNum(random);
        this.handleBlockSpawning(world, random, pos, blocknum, rotate);
    }

    private void handleBlockSpawning(World world, Random random, BlockPos pos, int blocknum, int rotate) {
        BlockState blockState = this.blockStates[blocknum];
        if (blockState != null) {
            BlockState rotatedState = blockState.rotate((IWorld)world, pos, RuinTemplateRule.getDirectionalRotation(rotate));
            if (this.excessiveDebugging) {
                RuinsMod.LOGGER.info("About to place blockstate {} at pos {}", (Object)rotatedState.toString(), (Object)pos.toString());
            }
            this.realizeBlock(world, pos, rotatedState, this.tileEntityData[blocknum]);
            int bonemeal = this.blockBonemeals[blocknum];
            if (bonemeal > 0) {
                this.owner.markBlockForBonemeal(pos, bonemeal);
            }
        }
    }

    private int getBlockNum(Random random) {
        int blockIndex = 0;
        double selector = random.nextDouble() * this.blockWeightsTotal;
        while (true) {
            double d;
            selector -= this.blockWeights[blockIndex];
            if (!(d >= 0.0)) break;
            ++blockIndex;
        }
        return blockIndex;
    }

    private void realizeBlock(World world, BlockPos position, BlockState blockState, CompoundNBT tileEntityData) {
        if (world != null && blockState != null) {
            TileEntity entity;
            TileEntity existing_entity = world.func_175625_s(position);
            if (existing_entity != null) {
                if (existing_entity instanceof IInventory) {
                    ((IInventory)existing_entity).func_174888_l();
                }
                world.func_180501_a(position, Blocks.field_150350_a.func_176223_P(), 4);
            }
            if (world.func_180501_a(position, blockState, 2) && (entity = world.func_175625_s(position)) != null && tileEntityData != null) {
                entity = TileEntity.func_203403_c((CompoundNBT)entity.func_189515_b(new CompoundNBT()).func_197643_a(tileEntityData));
                world.func_175690_a(position, entity);
                if (entity instanceof LockableLootTileEntity) {
                    CompoundNBT nbtTagCompound = entity.getTileData();
                    if (nbtTagCompound.func_74764_b("ForgeData")) {
                        nbtTagCompound = nbtTagCompound.func_74775_l("ForgeData");
                    }
                    if (nbtTagCompound.func_74764_b("LootTable")) {
                        String lootTable = nbtTagCompound.func_74779_i("LootTable");
                        long lootSeed = nbtTagCompound.func_74763_f("LootTableSeed");
                        LockableLootTileEntity tileEntityLockableLoot = (LockableLootTileEntity)entity;
                        tileEntityLockableLoot.func_189404_a(new ResourceLocation(lootTable), lootSeed);
                        tileEntityLockableLoot.func_184281_d(null);
                    }
                }
            }
        }
    }
}

