/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.ChunkLoggerData;
import atomicstryker.ruins.common.CommandParseTemplate;
import atomicstryker.ruins.common.CommandTestTemplate;
import atomicstryker.ruins.common.CommandUndoTemplate;
import atomicstryker.ruins.common.ConfigFolderPreparator;
import atomicstryker.ruins.common.FileHandler;
import atomicstryker.ruins.common.IProxy;
import atomicstryker.ruins.common.RuinGenerator;
import atomicstryker.ruins.common.RuinsClient;
import atomicstryker.ruins.common.RuinsServer;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="ruins")
@Mod.EventBusSubscriber(modid="ruins", value={Dist.DEDICATED_SERVER})
public class RuinsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String TEMPLATE_PATH_MC_EXTRACTED = "config/ruins_config/";
    public static final String TEMPLATE_PATH_JAR = "ruins_config";
    public static final int DIR_NORTH = 0;
    public static final int DIR_EAST = 1;
    public static final int DIR_SOUTH = 2;
    public static final int DIR_WEST = 3;
    public static final String BIOME_ANY = "generic";
    static final String MOD_ID = "ruins";
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new RuinsClient(), () -> () -> new RuinsServer());
    private static RuinsMod instance = null;
    private final ConcurrentHashMap<Dimension, WorldHandle> generatorMap;
    private long nextInfoTime;
    private static final ConfiguredFeature<?, ?> PSEUDOFEATURE = new Feature<NoFeatureConfig>(NoFeatureConfig::func_214639_a){

        public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos block_pos, NoFeatureConfig config) {
            RuinsMod.decorateChunkHook((WorldGenRegion)world);
            return false;
        }
    }.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e);

    public RuinsMod() {
        instance = this;
        this.generatorMap = new ConcurrentHashMap();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::preInit);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new CommandParseTemplate());
        MinecraftForge.EVENT_BUS.register((Object)new CommandUndoTemplate());
        LOGGER.info("Ruins instance built, events registered");
    }

    private static File getWorldSaveDir(IWorld iWorld) {
        if (iWorld instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)iWorld;
            return world.func_217485_w().func_75765_b();
        }
        return null;
    }

    public static File getMinecraftBaseDir() {
        return proxy.getBaseDir();
    }

    public static void decorateChunkHook(WorldGenRegion worldGenRegion) {
        if (worldGenRegion.func_201670_d() || !worldGenRegion.func_72912_H().func_76089_r() || instance == null) {
            return;
        }
        final ServerWorld world = worldGenRegion.func_201672_e();
        int x = worldGenRegion.func_201679_a();
        int z = worldGenRegion.func_201680_b();
        final ChunkPos chunkPos = new ChunkPos(x, z);
        LOGGER.trace("Ruins chunk decoration [{}|{}]", (Object)x, (Object)z);
        final WorldHandle wh = instance.getWorldHandle(world);
        if (wh != null) {
            if (wh.currentlyGenerating.contains(chunkPos)) {
                LOGGER.error("Ruins Mod caught recursive generator call at chunk {}", (Object)chunkPos);
            } else if (wh.fileHandle.allowsDimension(world.func_201675_m().func_186058_p().func_186068_a()) && (wh.chunkLogger == null || !wh.chunkLogger.catchChunkBug(chunkPos))) {
                wh.currentlyGenerating.add(chunkPos);
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        world.func_73046_m().func_213165_a(() -> {
                            if (world.func_201675_m().func_177495_o()) {
                                instance.generateNether(world, world2.field_73012_v, chunkPos.func_180334_c(), chunkPos.func_180333_d());
                            } else {
                                instance.generateSurface(world, world2.field_73012_v, chunkPos.func_180334_c(), chunkPos.func_180333_d());
                            }
                            wh2.currentlyGenerating.remove(chunkPos);
                        });
                    }
                }, 15000L);
            }
        }
    }

    public void preInit(FMLCommonSetupEvent evt) {
        LOGGER.info("Ruins preInit");
        ConfigFolderPreparator.copyFromJarIfNotPresent(this, new File(RuinsMod.getMinecraftBaseDir(), TEMPLATE_PATH_MC_EXTRACTED));
        for (Biome biome : ForgeRegistries.BIOMES) {
            biome.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, PSEUDOFEATURE);
        }
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartingEvent evt) {
        LOGGER.info("Ruins serverStarted");
        evt.getCommandDispatcher().register(CommandParseTemplate.BUILDER);
        evt.getCommandDispatcher().register(CommandTestTemplate.BUILDER);
        evt.getCommandDispatcher().register(CommandUndoTemplate.BUILDER);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack is;
        WorldHandle wh;
        if (event.getEntity().func_130014_f_() instanceof ServerWorld && (wh = this.getWorldHandle((ServerWorld)event.getEntity().func_130014_f_())) != null && wh.fileHandle.enableStick && (is = event.getPlayer().func_184614_ca()).func_77973_b() == Items.field_151055_y && System.currentTimeMillis() > this.nextInfoTime) {
            this.nextInfoTime = System.currentTimeMillis() + 1000L;
            TileEntity te = event.getPlayer().field_70170_p.func_175625_s(event.getPos());
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent(RuleStringNbtHelper.StringFromBlockState(event.getState(), te), new Object[0]));
        }
    }

    @SubscribeEvent
    public void onBreak(BlockEvent.BreakEvent event) {
        ItemStack is;
        WorldHandle wh;
        if (event.getPlayer() != null && !(event.getPlayer() instanceof FakePlayer) && event.getWorld() instanceof ServerWorld && (wh = this.getWorldHandle((ServerWorld)event.getWorld())) != null && wh.fileHandle.enableStick && (is = event.getPlayer().func_184614_ca()).func_77973_b() == Items.field_151055_y && System.currentTimeMillis() > this.nextInfoTime) {
            this.nextInfoTime = System.currentTimeMillis() + 1000L;
            TileEntity te = event.getPlayer().field_70170_p.func_175625_s(event.getPos());
            event.getPlayer().func_145747_a((ITextComponent)new TranslationTextComponent(RuleStringNbtHelper.StringFromBlockState(event.getState(), te), new Object[0]));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void eventWorldSave(WorldEvent.Save evt) {
        WorldHandle wh;
        if (evt.getWorld() instanceof ServerWorld && (wh = this.getWorldHandle((ServerWorld)evt.getWorld())) != null) {
            wh.generator.flushPosFile(evt.getWorld().func_72912_H().func_76065_j());
        }
    }

    @SubscribeEvent
    public void onEntityEnteringChunk(EntityEvent.EnteringChunk event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K) {
            event.getEntity().field_70170_p.func_73046_m().func_213165_a(() -> this.executeCommandBlockLogic(event));
        }
    }

    private void executeCommandBlockLogic(EntityEvent.EnteringChunk event) {
        ArrayList<CommandBlockTileEntity> tecblist = new ArrayList<CommandBlockTileEntity>();
        for (int xoffset = -4; xoffset <= 4; ++xoffset) {
            for (int zoffset = -4; zoffset <= 4; ++zoffset) {
                if (!event.getEntity().field_70170_p.func_217354_b(event.getNewChunkX() + xoffset, event.getNewChunkZ() + zoffset)) continue;
                for (TileEntity teo : event.getEntity().field_70170_p.func_212866_a_(event.getNewChunkX() + xoffset, event.getNewChunkZ() + zoffset).func_177434_r().values()) {
                    CommandBlockTileEntity tecb;
                    if (!(teo instanceof CommandBlockTileEntity) || !(tecb = (CommandBlockTileEntity)teo).func_145993_a().func_145753_i().startsWith("RUINSTRIGGER ")) continue;
                    tecb.func_145993_a().func_145752_a(tecb.func_145993_a().func_145753_i().substring(13));
                    tecblist.add(tecb);
                }
            }
        }
        for (CommandBlockTileEntity tecb2 : tecblist) {
            tecb2.func_145993_a().func_145755_a(event.getEntity().field_70170_p);
            BlockPos pos = tecb2.func_174877_v();
            LOGGER.info("Ruins executed and killed Command Block at [{}]", (Object)pos);
            event.getEntity().field_70170_p.func_217377_a(pos, false);
        }
    }

    private void generateNether(ServerWorld world, Random random, int chunkX, int chunkZ) {
        WorldHandle wh = this.getWorldHandle(world);
        if (wh.fileHandle != null) {
            while (!wh.fileHandle.loaded) {
                Thread.yield();
            }
            wh.generator.generateNether((World)world, random, chunkX, chunkZ);
        }
    }

    private void generateSurface(ServerWorld world, Random random, int chunkX, int chunkZ) {
        WorldHandle wh = this.getWorldHandle(world);
        if (wh.fileHandle != null) {
            while (!wh.fileHandle.loaded) {
                Thread.yield();
            }
            wh.generator.generateNormal((World)world, random, chunkX, chunkZ);
        }
    }

    private WorldHandle getWorldHandle(ServerWorld world) {
        WorldHandle wh = null;
        if (!world.func_201670_d()) {
            Dimension dimension = world.field_73011_w;
            if (!this.generatorMap.containsKey(dimension)) {
                wh = new WorldHandle();
                this.initWorldHandle(wh, world);
                this.generatorMap.put(dimension, wh);
            } else {
                wh = this.generatorMap.get(dimension);
            }
        }
        return wh;
    }

    private void initWorldHandle(WorldHandle worldHandle, ServerWorld world) {
        try {
            File worlddir = RuinsMod.getWorldSaveDir((IWorld)world);
            LOGGER.info("Ruins mod determines World Save Dir to be at: {}", (Object)worlddir);
            worldHandle.fileHandle = new FileHandler(worlddir, world.func_201675_m().func_186058_p());
            worldHandle.generator = new RuinGenerator(worldHandle.fileHandle, world.func_201672_e());
            worldHandle.currentlyGenerating = new ConcurrentLinkedQueue();
            worldHandle.chunkLogger = (ChunkLoggerData)world.func_217481_x().func_215753_b(() -> new ChunkLoggerData("ruinschunklogger"), "ruinschunklogger");
        }
        catch (Exception e) {
            LOGGER.error("There was a problem loading the ruins mod:");
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private class WorldHandle {
        FileHandler fileHandle;
        RuinGenerator generator;
        ConcurrentLinkedQueue<ChunkPos> currentlyGenerating;
        ChunkLoggerData chunkLogger;

        private WorldHandle() {
        }
    }
}

