/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.ruins.common;

import atomicstryker.ruins.common.CommandTestTemplate;
import atomicstryker.ruins.common.FileHandler;
import atomicstryker.ruins.common.RuinTemplate;
import atomicstryker.ruins.common.RuinsMod;
import atomicstryker.ruins.common.RuleStringNbtHelper;
import com.google.common.collect.ImmutableList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTables;

class World2TemplateParser
extends Thread {
    private final BlockData templateHelperBlock;
    private final BlockData nothing = new BlockData(Blocks.field_150350_a.func_176223_P(), null);
    private final List<String> chestLootTableNamesToGenerate = ImmutableList.of((Object)LootTables.field_186422_d.toString(), (Object)LootTables.field_204312_r.toString(), (Object)LootTables.field_186424_f.toString(), (Object)LootTables.field_186428_j.toString(), (Object)LootTables.field_186427_i.toString(), (Object)LootTables.field_186426_h.toString());
    private final int x;
    private final int y;
    private final int z;
    private final ArrayList<BlockData> usedBlocks;
    private final World world;
    private final String fileName;
    private final PlayerEntity player;
    private int lowestX;
    private int lowestZ;
    private int xLength;
    private int zLength;
    private int yPadding;
    private ArrayList<BlockData[][]> layerData;
    private int blocker;

    public World2TemplateParser(PlayerEntity p, int a, int b, int c, String fName) {
        this.player = p;
        this.world = p.field_70170_p;
        this.x = a;
        this.y = b;
        this.z = c;
        this.fileName = fName;
        BlockState state = this.world.func_180495_p(new BlockPos(a, b, c));
        this.templateHelperBlock = new BlockData(state, null);
        this.usedBlocks = new ArrayList();
        this.layerData = new ArrayList();
    }

    @Override
    public void run() {
        if (this.templateHelperBlock.blockState.func_177230_c() == Blocks.field_150350_a) {
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Template Parse fail, chosen Block was air WTF?!", new Object[0]));
            return;
        }
        this.blocker = 0;
        this.lowestX = this.x - 1;
        while (this.templateHelperBlock.matchesBlock(this.world, this.lowestX, this.y, this.z)) {
            --this.lowestX;
            this.checkLockup();
        }
        ++this.lowestX;
        this.blocker = 0;
        this.lowestZ = this.z - 1;
        while (this.templateHelperBlock.matchesBlock(this.world, this.x, this.y, this.lowestZ)) {
            --this.lowestZ;
            this.checkLockup();
        }
        ++this.lowestZ;
        this.blocker = 0;
        int xmax = this.x + 1;
        while (this.templateHelperBlock.matchesBlock(this.world, xmax, this.y, this.z)) {
            ++xmax;
            this.checkLockup();
        }
        this.xLength = 1 + --xmax - this.lowestX;
        this.blocker = 0;
        int zmax = this.z + 1;
        while (this.templateHelperBlock.matchesBlock(this.world, this.x, this.y, zmax)) {
            ++zmax;
            this.checkLockup();
        }
        this.zLength = 1 + --zmax - this.lowestZ;
        this.readBlocks(this.world);
        this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Block reading finished. Rules: " + this.usedBlocks.size() + ", layers: " + this.layerData.size() + ", xlen: " + this.xLength + ", zlen: " + this.zLength, new Object[0]));
        File folder = new File(RuinsMod.getMinecraftBaseDir(), "config/ruins_config/templateparser/");
        if (!folder.exists()) {
            if (!folder.mkdirs()) {
                this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Failed to create folder structure: " + folder, new Object[0]));
                return;
            }
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Created folder structure: " + folder, new Object[0]));
        }
        File templateFile = new File(folder, this.fileName + ".tml");
        this.toFile(templateFile);
        this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Success writing templatefile " + templateFile, new Object[0]));
    }

    private void checkLockup() {
        if (this.blocker++ > 1024) {
            throw new IndexOutOfBoundsException("Runaway loop detected! Did you hit the ground?!");
        }
    }

    private void readBlocks(World world) {
        this.yPadding = 0;
        int highestY = this.y + 1;
        BlockData temp = this.nothing.copy();
        this.blocker = 0;
        int yi = this.y + 1;
        while (true) {
            BlockData[][] currentLayer = new BlockData[this.xLength][this.zLength];
            this.layerData.add(currentLayer);
            if (yi > highestY + 100) {
                this.layerData = new ArrayList<BlockData[][]>(this.layerData.subList(this.yPadding, highestY - this.y));
                return;
            }
            this.checkLockup();
            for (int xi = 0; xi < this.xLength; ++xi) {
                for (int zi = 0; zi < this.zLength; ++zi) {
                    BlockData currentinstance;
                    int indexInList;
                    int blockx = xi + this.lowestX;
                    int blocky = yi;
                    int blockz = zi + this.lowestZ;
                    BlockPos pos = new BlockPos(blockx, blocky, blockz);
                    temp.blockState = world.func_180495_p(pos);
                    temp.tileEntity = world.func_175625_s(pos);
                    if (temp.blockState.func_177230_c() == Blocks.field_150350_a || temp.equals(this.templateHelperBlock)) {
                        currentLayer[xi][zi] = this.nothing;
                        continue;
                    }
                    if (highestY == -1) {
                        this.yPadding = yi - this.y;
                    }
                    highestY = yi;
                    if (temp.tileEntity instanceof ChestTileEntity && this.isIInventoryEmpty((IInventory)temp.tileEntity)) {
                        CompoundNBT teData = temp.tileEntity.getTileData();
                        teData.func_74778_a("LootTable", this.chestLootTableNamesToGenerate.get(world.field_73012_v.nextInt(this.chestLootTableNamesToGenerate.size())));
                        teData.func_74772_a("LootTableSeed", world.field_73012_v.nextLong());
                    }
                    if ((indexInList = this.usedBlocks.indexOf(temp)) == -1) {
                        currentinstance = temp.copy();
                        this.usedBlocks.add(currentinstance);
                    } else {
                        currentinstance = this.usedBlocks.get(indexInList);
                    }
                    currentLayer[xi][zi] = currentinstance;
                }
            }
            ++yi;
        }
    }

    private boolean isIInventoryEmpty(IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (inventory.func_70301_a(slot) == ItemStack.field_190927_a) continue;
            return false;
        }
        return true;
    }

    private void toFile(File file) {
        try {
            if (file.exists() ? !file.delete() : !file.createNewFile()) {
                throw new RuntimeException("Ruins crashed trying to access file " + file);
            }
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println();
            pw.println("# Created by Ruins mod Ingame Parser");
            pw.println("# authoring Player: " + this.player.func_200200_C_().getString());
            pw.println();
            pw.println("# TEMPLATE PARAMETER SETTINGS:");
            pw.println("#");
            pw.println("# criterion expression specifying mod ids required to load template");
            pw.println("# may include plus (AND), minus (AND NOT), comma (OR), and parentheses");
            pw.println("# all required mods listed must be present; no prohibited mods can be");
            pw.println("requiredMods=");
            pw.println("#");
            pw.println("# likelihood this template will be chosen relative to all others");
            pw.println("# e.g., a weight=6 template is chosen 3X as often as one with weight=2");
            pw.println("weight=1");
            pw.println("#");
            pw.println("# list of dimensions in which this template may spawn, even if generic");
            pw.println("# one or more dimension names, separated by commas (blank = all)");
            pw.println("dimensionsToSpawnIn=");
            pw.println("#");
            pw.println("# list of other biomes in which this template may spawn");
            pw.println("# biome corresponding to directory is always assumed, listed or not");
            pw.println("# generic templates should leave this list empty");
            pw.println("biomesToSpawnIn=");
            pw.println("#");
            pw.println("# criterion expression specifying types of biome where template spawns");
            pw.println("# this is in addition to those explicitly listed as biomesToSpawnIn");
            pw.println("# generic templates should leave this list empty");
            pw.println("biomeTypesToSpawnIn=");
            pw.println("#");
            pw.println("# list of biomes in which this template may not spawn");
            pw.println("# takes precedence over biomeTypesToSpawnIn, but NOT biomesToSpawnIn");
            pw.println("# should be empty if biomeTypesToSpawnIn is empty");
            pw.println("biomesToNotSpawnIn=");
            pw.println("#");
            pw.println("# depth template is pushed down into the surface when built");
            pw.println("# offset is min/max range of random additional bury depth");
            pw.println("embed_into_distance=" + this.yPadding);
            pw.println("random_height_offset=0,0");
            pw.println("#");
            pw.println("# whitelist/blacklist of block states on which template may be built");
            pw.println("# specify one, not both; leave the other empty (both empty = allow all)");
            pw.println("# CAUTION: THE DEFAULTS ONLY APPLY TO NON-FLOWING LAVA AND WATER VARIANTS)");
            pw.println("acceptable_target_blocks=");
            String water = RuleStringNbtHelper.StringFromBlockState(Blocks.field_150355_j.func_176223_P(), null);
            String lava = RuleStringNbtHelper.StringFromBlockState(Blocks.field_150353_l.func_176223_P(), null);
            pw.printf("unacceptable_target_blocks=%s,%s\n", water, lava);
            pw.println("#");
            pw.println("# size of template (#layers, #rows per layer, #blocks per row)");
            pw.println("dimensions=" + this.layerData.size() + "," + this.xLength + "," + this.zLength);
            pw.println("#");
            pw.println("# max number of missing blocks allowed in surface beneath template");
            pw.println("allowable_overhang=0");
            pw.println("#");
            pw.println("# depth/height limit affected by terrain leveling");
            pw.println("# also maximum bumpiness tolerated in surface beneath template");
            pw.println("max_leveling=2");
            pw.println("#");
            pw.println("# padding applied to all sides of template horizontal footprint");
            pw.println("# expands area affected by terrain leveling (-1 = no leveling)");
            pw.println("leveling_buffer=0");
            pw.println("#");
            pw.println("# do not rotate template randomly when built (1 = no rotation)");
            pw.println("preventRotation=0");
            pw.println("#");
            pw.println("# treat water/lava blocks as air and protect them from rule0 (1 = yes)");
            pw.println("preserve_water=0");
            pw.println("preserve_lava=0");
            pw.println("#");
            pw.println("# minimum distance this template must have from instances of itself");
            pw.println("uniqueMinDistance=0");
            pw.println("#");
            pw.println("# min/max distances this template can be from world spawn (0 = no limit)");
            pw.println("# only applies to overworld--i.e., dimension 0");
            pw.println("spawnMinDistance=0");
            pw.println("spawnMaxDistance=0");
            pw.println("#");
            pw.println("# other template built nearby whenever this one is");
            pw.println("# syntax: <name>;<relativeX>;<maxYdifference>;<relativeZ>[;<chance>]");
            pw.println("# may be used more than once to specify multiple neighbors");
            pw.println("adjoining_template=");
            pw.println();
            NumberFormat id_formatter = NumberFormat.getIntegerInstance();
            if (FileHandler.enableFixedWidthRuleIds && id_formatter instanceof DecimalFormat) {
                int count = this.usedBlocks.size();
                ((DecimalFormat)id_formatter).applyPattern(count < 10 ? "0" : (count < 100 ? "00" : (count < 1000 ? "000" : "0")));
            }
            int rulenum = 1;
            for (BlockData bd : this.usedBlocks) {
                pw.println("rule" + id_formatter.format(rulenum) + "=" + bd.toString());
                ++rulenum;
            }
            pw.println();
            for (BlockData[][] layer : this.layerData) {
                pw.println("layer");
                for (BlockData[] aLayer : layer) {
                    int j = 0;
                    int j2 = layer[0].length - 1;
                    while (j < layer[0].length) {
                        pw.print(id_formatter.format(this.usedBlocks.indexOf(aLayer[j2]) + 1));
                        if (j < layer[0].length - 1) {
                            pw.print(",");
                        }
                        ++j;
                        --j2;
                    }
                    pw.println();
                }
                pw.println("endlayer");
                pw.println();
            }
            pw.close();
            CommandTestTemplate.parsedRuin = new RuinTemplate(file.getCanonicalPath(), file.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("Something broke! See server logfile for exception message and get it to AtomicStryker.", new Object[0]));
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("First line of stacktrace: " + e.getMessage(), new Object[0]));
        }
    }

    private class BlockData {
        BlockState blockState;
        TileEntity tileEntity;

        BlockData(BlockState state, TileEntity te) {
            this.blockState = state;
            this.tileEntity = te;
        }

        BlockData copy() {
            return new BlockData(this.blockState, this.tileEntity);
        }

        boolean matchesBlock(World w, int x, int y, int z) {
            return w.func_180495_p(new BlockPos(x, y, z)) == this.blockState;
        }

        public String toString() {
            return String.format("%s", RuleStringNbtHelper.StringFromBlockState(this.blockState, this.tileEntity));
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof BlockData && o.toString().equals(this.toString());
        }
    }
}

