/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import net.blay09.mods.trashslot.CommonProxy;
import net.blay09.mods.trashslot.SlotTrash;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.client.GuiTrashSlot;
import net.blay09.mods.trashslot.net.MessageDelete;
import net.blay09.mods.trashslot.net.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class ClientProxy
extends CommonProxy {
    public static TextureAtlasSprite trashSlotIcon;
    private static final int HELLO_TIMEOUT = 200;
    private final KeyBinding keyBindDelete = new KeyBinding("key.trashslot.delete", (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, 211, "key.categories.trashslot");
    private int helloTimeout;
    private boolean isEnabled;
    private GuiTrashSlot guiTrashSlot;
    private boolean wasInCreative;
    private boolean neiLoaded;

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBindDelete);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.neiLoaded = Loader.isModLoaded((String)"NotEnoughItems");
    }

    @Override
    public void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @SubscribeEvent
    public void connectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.helloTimeout = 200;
        this.isEnabled = false;
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (this.isEnabled && event.getEntity() == Minecraft.func_71410_x().field_71439_g && this.findSlotTrash(Minecraft.func_71410_x().field_71439_g.field_71069_bz) == null) {
            this.patchContainer((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71439_g.field_71069_bz);
        }
    }

    @Override
    @SubscribeEvent
    public void onOpenContainer(PlayerOpenContainerEvent event) {
        if (event.getEntityPlayer().field_71070_bA instanceof GuiContainerCreative.ContainerCreative) {
            this.unpatchContainer(event.getEntityPlayer().field_71069_bz);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        if (entityPlayer != null) {
            if (this.helloTimeout > 0) {
                --this.helloTimeout;
                if (this.helloTimeout <= 0) {
                    this.isEnabled = false;
                    this.unpatchContainer(entityPlayer.field_71069_bz);
                    entityPlayer.func_145747_a((ITextComponent)new TextComponentString("This server does not have TrashSlot installed. It will be disabled."));
                }
            }
            if (!this.isEnabled) {
                return;
            }
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (this.wasInCreative && !(gui instanceof GuiContainerCreative)) {
                if (this.findSlotTrash(entityPlayer.field_71069_bz) == null) {
                    Slot trashSlot;
                    this.patchContainer((EntityPlayer)entityPlayer, entityPlayer.field_71069_bz);
                    if (gui instanceof GuiInventory && (trashSlot = this.findSlotTrash(((GuiInventory)gui).field_147002_h)) != null) {
                        this.guiTrashSlot = new GuiTrashSlot((GuiInventory)gui, trashSlot);
                    }
                }
                this.wasInCreative = false;
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        trashSlotIcon = event.getMap().func_174942_a(new ResourceLocation("trashslot", "items/trashcan"));
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (this.isEnabled && event.getGui() instanceof GuiContainerCreative) {
            this.unpatchContainer(Minecraft.func_71410_x().field_71439_g.field_71069_bz);
            this.wasInCreative = true;
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (this.isEnabled && event.getGui() instanceof GuiInventory) {
            GuiInventory gui = (GuiInventory)event.getGui();
            Slot trashSlot = this.findSlotTrash(gui.field_147002_h);
            if (trashSlot != null) {
                this.guiTrashSlot = new GuiTrashSlot(gui, trashSlot);
            }
        }
    }

    @SubscribeEvent
    public void onGuiKeyboard(GuiScreenEvent.KeyboardInputEvent.Post event) {
        Slot mouseSlot;
        EntityPlayerSP entityPlayer;
        if (this.isEnabled && TrashSlot.enableDeleteKey && Keyboard.getEventKeyState() && this.keyBindDelete.isActiveAndMatches(Keyboard.getEventKey()) && (entityPlayer = Minecraft.func_71410_x().field_71439_g) != null && entityPlayer.field_71070_bA == entityPlayer.field_71069_bz && event.getGui() instanceof GuiContainer && (mouseSlot = ((GuiContainer)event.getGui()).getSlotUnderMouse()) != null && mouseSlot.func_75216_d() && (mouseSlot.field_75224_c == entityPlayer.field_71071_by && mouseSlot.getSlotIndex() < entityPlayer.field_71071_by.func_70302_i_() || mouseSlot instanceof SlotTrash)) {
            NetworkHandler.instance.sendToServer((IMessage)new MessageDelete(mouseSlot.field_75222_d, Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (event.getGui() instanceof GuiInventory) {
            if (this.neiLoaded) {
                ((GuiInventory)event.getGui()).field_147003_i = event.getGui().field_146294_l / 2 - ((GuiInventory)event.getGui()).field_146999_f / 2;
                ((GuiInventory)event.getGui()).field_147009_r = event.getGui().field_146295_m / 2 - ((GuiInventory)event.getGui()).field_147000_g / 2;
            }
            if (this.guiTrashSlot != null) {
                this.guiTrashSlot.update(event.getMouseX(), event.getMouseY());
                this.guiTrashSlot.drawBackground(event.getMouseX(), event.getMouseY());
            }
        }
    }

    @Override
    public void receivedHello(EntityPlayer entityPlayer) {
        super.receivedHello(entityPlayer);
        this.helloTimeout = 0;
        this.isEnabled = true;
    }
}

