/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import javax.annotation.Nullable;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.client.deletion.CreativeDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DefaultDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="trashslot", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TrashSlotConfig {
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    private static DeletionProvider deletionProvider;

    @SubscribeEvent
    public static void onConfig(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            deletionProvider = null;
        }
    }

    @Nullable
    public static DeletionProvider getDeletionProvider() {
        if (TrashSlot.isServerSideInstalled && deletionProvider == null) {
            deletionProvider = (Boolean)TrashSlotConfig.CLIENT.instantDeletion.get() != false ? new CreativeDeletionProvider() : new DefaultDeletionProvider();
        }
        return deletionProvider;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue instantDeletion;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client only settings").push("client");
            this.instantDeletion = builder.comment("This causes the deletion slot to delete items instantly, similar to Creative Mode.").translation("trashslot.config.instantDeletion").define("instantDeletion", false);
        }
    }
}

