/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import tschipp.carryon.common.helper.InvalidConfigException;
import tschipp.carryon.common.helper.StringParser;

public class ScriptParseHelper {
    public static boolean matches(double number, String cond) {
        if (cond == null) {
            return true;
        }
        try {
            if (cond.contains("<=")) {
                return number <= Double.parseDouble(cond.replace("<=", ""));
            }
            if (cond.contains(">=")) {
                return number >= Double.parseDouble(cond.replace(">=", ""));
            }
            if (cond.contains("<")) {
                return number < Double.parseDouble(cond.replace("<", ""));
            }
            if (cond.contains(">")) {
                return number > Double.parseDouble(cond.replace(">", ""));
            }
            if (cond.contains("=")) {
                return number == Double.parseDouble(cond.replace("=", ""));
            }
            return number == Double.parseDouble(cond);
        }
        catch (Exception e) {
            new InvalidConfigException(e.getMessage()).printException();
            return false;
        }
    }

    public static boolean matches(Block block, String cond) {
        if (cond == null) {
            return true;
        }
        Block toCheck = StringParser.getBlock(cond);
        if (toCheck != null) {
            return block == toCheck;
        }
        return false;
    }

    public static boolean matches(NBTTagCompound toCheck, NBTTagCompound toMatch) {
        if (toCheck == null || toMatch == null) {
            return true;
        }
        boolean matching = true;
        for (String key : toMatch.func_150296_c()) {
            NBTBase tagToCheck;
            NBTBase tag = toMatch.func_74781_a(key);
            if (tag.equals((Object)(tagToCheck = toCheck.func_74781_a(key = key.replace("\"", ""))))) continue;
            matching = false;
        }
        return matching;
    }

    public static double[] getXYZArray(String s) {
        double[] d = new double[]{ScriptParseHelper.getValueFromString(s, "x"), ScriptParseHelper.getValueFromString(s, "y"), ScriptParseHelper.getValueFromString(s, "z")};
        return d;
    }

    public static double[] getScale(String s) {
        double[] d = new double[]{ScriptParseHelper.getScaleValueFromString(s, "x"), ScriptParseHelper.getScaleValueFromString(s, "y"), ScriptParseHelper.getScaleValueFromString(s, "z")};
        return d;
    }

    public static double getScaleValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null) {
            return 1.0;
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            double numb = 1.0;
            string = string.replace(key + "=", "");
            try {
                numb = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return numb;
        }
        return 1.0;
    }

    public static Achievement getAchievementFromString(String s) {
        if (s == null) {
            return null;
        }
        for (Achievement a : AchievementList.field_187981_e) {
            if (!a.field_75975_e.equals(s)) continue;
            return a;
        }
        return null;
    }

    public static boolean matchesScore(EntityPlayer player, String cond) {
        Score sc;
        if (cond == null) {
            return true;
        }
        Scoreboard score = player.func_96123_co();
        int iE = cond.indexOf("=");
        int iG = cond.indexOf(">");
        int iL = cond.indexOf("<");
        String numb = iG == -1 || iE < iG && iL == -1 || iE < iL && iE != -1 ? cond.substring(iE) : (iE == -1 || iG < iE && iL == -1 || iG < iL && iG != -1 ? cond.substring(iG) : cond.substring(iL));
        String scorename = cond.replace(numb, "");
        Map o = score.func_96510_d(player.func_146103_bH().getName());
        if (o != null && (sc = (Score)o.get(score.func_96518_b(scorename))) != null) {
            int points = sc.func_96652_c();
            return ScriptParseHelper.matches(points, numb);
        }
        return false;
    }

    public static boolean matches(BlockPos pos, String cond) {
        if (cond == null) {
            return true;
        }
        BlockPos blockpos = new BlockPos(ScriptParseHelper.getValueFromString(cond, "x"), ScriptParseHelper.getValueFromString(cond, "y"), ScriptParseHelper.getValueFromString(cond, "z"));
        BlockPos expand = new BlockPos(ScriptParseHelper.getValueFromString(cond, "dx"), ScriptParseHelper.getValueFromString(cond, "dy"), ScriptParseHelper.getValueFromString(cond, "dz"));
        BlockPos expanded = blockpos.func_177971_a((Vec3i)expand);
        boolean x = pos.func_177958_n() >= blockpos.func_177958_n() && pos.func_177958_n() <= expanded.func_177958_n() || blockpos.func_177958_n() == 0;
        boolean y = pos.func_177956_o() >= blockpos.func_177956_o() && pos.func_177956_o() <= expanded.func_177956_o() || blockpos.func_177956_o() == 0;
        boolean z = pos.func_177952_p() >= blockpos.func_177952_p() && pos.func_177952_p() <= expanded.func_177952_p() || blockpos.func_177952_p() == 0;
        return x && y && z;
    }

    public static double getValueFromString(String toGetFrom, String key) {
        String[] s;
        if (toGetFrom == null) {
            return 0.0;
        }
        for (String string : s = toGetFrom.split(",")) {
            if (!string.contains(key) || !string.contains("=")) continue;
            double numb = 0.0;
            string = string.replace(key + "=", "");
            try {
                numb = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return numb;
        }
        return 0.0;
    }

    public static boolean hasEffects(EntityPlayer player, String cond) {
        if (cond == null) {
            return true;
        }
        Collection effects = player.func_70651_bq();
        String[] potions = cond.split(",");
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Integer> levels = new ArrayList<Integer>();
        for (int i = 0; i < potions.length; ++i) {
            String pot = potions[i];
            if (pot.contains("#")) {
                String level = pot.substring(pot.indexOf("#"));
                String name = pot.substring(0, pot.indexOf("#"));
                level = level.replace("#", "");
                int lev = 0;
                try {
                    lev = Integer.parseInt(level);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                levels.add(lev);
                names.add(name);
                continue;
            }
            levels.add(0);
            names.add(pot);
        }
        int matches = 0;
        for (PotionEffect effect : effects) {
            int idx;
            int lev;
            int amp = effect.func_76458_c();
            String name = effect.func_188419_a().getRegistryName().toString();
            if (!names.contains(name) || (lev = ((Integer)levels.get(idx = names.indexOf(name))).intValue()) != amp) continue;
            ++matches;
        }
        return matches == potions.length;
    }

    public static boolean matches(Material material, String cond) {
        if (cond == null) {
            return true;
        }
        switch (cond) {
            case "air": {
                return material == Material.field_151579_a;
            }
            case "anvil": {
                return material == Material.field_151574_g;
            }
            case "barrier": {
                return material == Material.field_175972_I;
            }
            case "cactus": {
                return material == Material.field_151570_A;
            }
            case "cake": {
                return material == Material.field_151568_F;
            }
            case "carpet": {
                return material == Material.field_151593_r;
            }
            case "circuits": {
                return material == Material.field_151594_q;
            }
            case "clay": {
                return material == Material.field_151571_B;
            }
            case "cloth": {
                return material == Material.field_151580_n;
            }
            case "coral": {
                return material == Material.field_151589_v;
            }
            case "dragon_egg": {
                return material == Material.field_151566_D;
            }
            case "fire": {
                return material == Material.field_151581_o;
            }
            case "glass": {
                return material == Material.field_151592_s;
            }
            case "gourd": {
                return material == Material.field_151572_C;
            }
            case "grass": {
                return material == Material.field_151577_b;
            }
            case "ground": {
                return material == Material.field_151578_c;
            }
            case "ice": {
                return material == Material.field_151588_w;
            }
            case "iron": {
                return material == Material.field_151573_f;
            }
            case "lava": {
                return material == Material.field_151587_i;
            }
            case "leaves": {
                return material == Material.field_151584_j;
            }
            case "packed_ice": {
                return material == Material.field_151598_x;
            }
            case "piston": {
                return material == Material.field_76233_E;
            }
            case "plants": {
                return material == Material.field_151585_k;
            }
            case "portal": {
                return material == Material.field_151567_E;
            }
            case "redstone_light": {
                return material == Material.field_151591_t;
            }
            case "rock": {
                return material == Material.field_151576_e;
            }
            case "sand": {
                return material == Material.field_151595_p;
            }
            case "snow": {
                return material == Material.field_151597_y;
            }
            case "sponge": {
                return material == Material.field_151583_m;
            }
            case "structure_void": {
                return material == Material.field_189963_J;
            }
            case "tnt": {
                return material == Material.field_151590_u;
            }
            case "vine": {
                return material == Material.field_151582_l;
            }
            case "water": {
                return material == Material.field_151586_h;
            }
            case "web": {
                return material == Material.field_151569_G;
            }
            case "wood": {
                return material == Material.field_151575_d;
            }
        }
        return false;
    }
}

