/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptReader;

public class ScriptChecker {
    @Nullable
    public static CarryOnOverride inspectBlock(IBlockState state, World world, BlockPos pos, @Nullable NBTTagCompound tag) {
        if (!CarryOnConfig.settings.useScripts) {
            return null;
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        Material material = state.func_185904_a();
        float hardness = state.func_185887_b(world, pos);
        float resistance = block.func_149638_a(null);
        NBTTagCompound nbt = tag;
        for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
            if (!override.isBlock() || !ScriptChecker.matchesAll(override, block, meta, material, hardness, resistance, nbt)) continue;
            return override;
        }
        return null;
    }

    @Nullable
    public static CarryOnOverride inspectEntity(Entity entity) {
        if (!CarryOnConfig.settings.useScripts) {
            return null;
        }
        String name = EntityList.func_75621_b((Entity)entity).toString();
        float height = entity.field_70131_O;
        float width = entity.field_70130_N;
        float health = entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110143_aJ() : 0.0f;
        NBTTagCompound tag = new NBTTagCompound();
        entity.func_189511_e(tag);
        for (CarryOnOverride override : ScriptReader.OVERRIDES.values()) {
            if (!override.isEntity() || !ScriptChecker.matchesAll(override, name, height, width, health, tag)) continue;
            return override;
        }
        return null;
    }

    public static boolean matchesAll(CarryOnOverride override, String name, float height, float width, float health, NBTTagCompound tag) {
        boolean matchname = override.getTypeNameEntity() == null ? true : name.equals(override.getTypeNameEntity());
        boolean matchheight = ScriptParseHelper.matches(height, override.getTypeHeight());
        boolean matchwidth = ScriptParseHelper.matches(width, override.getTypeWidth());
        boolean matchhealth = ScriptParseHelper.matches(health, override.getTypeHealth());
        boolean matchnbt = ScriptParseHelper.matches(tag, override.getTypeEntityTag());
        return matchname && matchheight && matchwidth && matchhealth && matchnbt;
    }

    public static boolean matchesAll(CarryOnOverride override, Block block, int meta, Material material, float hardness, float resistance, NBTTagCompound nbt) {
        boolean matchnbt = ScriptParseHelper.matches(nbt, override.getTypeBlockTag());
        boolean matchblock = ScriptParseHelper.matches(block, override.getTypeNameBlock());
        boolean matchmeta = ScriptParseHelper.matches(meta, override.getTypeMeta());
        boolean matchmaterial = ScriptParseHelper.matches(material, override.getTypeMaterial());
        boolean matchhardness = ScriptParseHelper.matches(hardness, override.getTypeHardness());
        boolean matchresistance = ScriptParseHelper.matches(resistance, override.getTypeResistance());
        return matchnbt && matchblock && matchmeta && matchmaterial && matchhardness && matchresistance;
    }

    public static boolean fulfillsConditions(CarryOnOverride override, EntityPlayer player) {
        boolean achievement = ScriptParseHelper.getAchievementFromString(override.getConditionAchievement()) == null ? true : player.func_189102_a(ScriptParseHelper.getAchievementFromString(override.getConditionAchievement()));
        boolean gamemode = ScriptParseHelper.matches(((EntityPlayerMP)player).field_71134_c.func_73081_b().func_77148_a(), override.getConditionGamemode());
        boolean position = ScriptParseHelper.matches(player.func_180425_c(), override.getConditionPosition());
        boolean xp = ScriptParseHelper.matches(player.field_71068_ca, override.getConditionXp());
        boolean scoreboard = ScriptParseHelper.matchesScore(player, override.getConditionScoreboard());
        boolean effects = ScriptParseHelper.hasEffects(player, override.getConditionEffects());
        return achievement && gamemode && position && xp && scoreboard && effects;
    }

    @Nullable
    public static CarryOnOverride getOverride(EntityPlayer player) {
        NBTTagCompound tag = player.getEntityData();
        if (tag != null && tag.func_74764_b("overrideKey")) {
            int key = tag.func_74762_e("overrideKey");
            return ScriptReader.OVERRIDES.get(key);
        }
        return null;
    }

    public static void setCarryOnOverride(EntityPlayer player, int i) {
        NBTTagCompound tag = player.getEntityData();
        if (tag != null) {
            tag.func_74768_a("overrideKey", i);
        }
    }
}

