/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.darkhax.gamestages.capabilities.PlayerDataHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.item.ItemTile;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class PickupHandler {
    public static boolean canPlayerPickUpBlock(EntityPlayer player, @Nullable TileEntity tile, World world, BlockPos pos) {
        String condition;
        PlayerDataHandler.IStageData stageData;
        double distance;
        CarryOnOverride override;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        player.func_71053_j();
        NBTTagCompound tag = new NBTTagCompound();
        if (tile != null) {
            tile.func_189515_b(tag);
        }
        if ((override = ScriptChecker.inspectBlock(world.func_180495_p(pos), world, pos, tag)) != null) {
            return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
        }
        if (CarryOnConfig.settings.useWhitelistBlocks) {
            if (!ListHandler.isAllowed(world.func_180495_p(pos).func_177230_c())) {
                return false;
            }
            CarryOn.LOGGER.info("Block is allowed");
        } else if (ListHandler.isForbidden(world.func_180495_p(pos).func_177230_c())) {
            return false;
        }
        if ((block.func_176195_g(state, world, pos) != -1.0f || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0) && !ItemTile.isLocked(pos, world) && (CustomPickupOverrideHandler.hasSpecialPickupConditions(state) ? (stageData = PlayerDataHandler.getStageData((EntityPlayer)player)).hasUnlockedStage(condition = CustomPickupOverrideHandler.getPickupCondition(state)) : CarryOnConfig.settings.pickupAllBlocks || tile != null)) {
            return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
        }
        return false;
    }

    public static boolean canPlayerPickUpEntity(EntityPlayer player, Entity toPickUp) {
        double distance;
        EntityAgeable living;
        BlockPos pos = toPickUp.func_180425_c();
        if (toPickUp instanceof EntityPlayer) {
            return false;
        }
        CarryOnOverride override = ScriptChecker.inspectEntity(toPickUp);
        if (override != null) {
            return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
        }
        if (toPickUp instanceof EntityAgeable && CarryOnConfig.settings.allowBabies && ((living = (EntityAgeable)toPickUp).func_70874_b() < 0 || living.func_70631_g_())) {
            EntityTameable tame;
            double distance2 = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
            if (distance2 < Math.pow(CarryOnConfig.settings.maxDistance, 2.0) && toPickUp instanceof EntityTameable && (tame = (EntityTameable)toPickUp).func_184753_b() != null) {
                if (tame.func_184753_b() != EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())) {
                    return false;
                }
            }
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                String condition;
                PlayerDataHandler.IStageData stageData = PlayerDataHandler.getStageData((EntityPlayer)player);
                if (stageData.hasUnlockedStage(condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp))) {
                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
            } else {
                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
            }
        }
        if (CarryOnConfig.settings.useWhitelistEntities ? !ListHandler.isAllowed(toPickUp) : ListHandler.isForbidden(toPickUp)) {
            return false;
        }
        if ((CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && (CarryOnConfig.settings.pickupHostileMobs || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && (toPickUp.field_70131_O <= CarryOnConfig.settings.maxEntityHeight && toPickUp.field_70130_N <= CarryOnConfig.settings.maxEntityWidth || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow(CarryOnConfig.settings.maxDistance, 2.0)) {
            if (toPickUp instanceof EntityTameable) {
                EntityTameable tame = (EntityTameable)toPickUp;
                UUID owner = tame.func_184753_b();
                UUID playerID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                if (owner != null && !owner.equals(playerID)) {
                    return false;
                }
            }
            if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                String condition;
                PlayerDataHandler.IStageData stageData = PlayerDataHandler.getStageData((EntityPlayer)player);
                if (stageData.hasUnlockedStage(condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp))) {
                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
            } else {
                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
            }
        }
        return false;
    }

    private static boolean handleProtections(EntityPlayerMP player, World world, BlockPos pos, IBlockState state) {
        boolean breakable = true;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            breakable = false;
        }
        return breakable;
    }

    private static boolean handleProtections(EntityPlayerMP player, Entity entity) {
        boolean canPickup = true;
        AttackEntityEvent event = new AttackEntityEvent((EntityPlayer)player, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            canPickup = false;
        }
        return canPickup;
    }
}

