/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.network.client.CarrySlotPacket;

public class ItemEntity
extends Item {
    public static final String ENTITY_DATA_KEY = "entityData";

    public ItemEntity() {
        this.func_77655_b("entity_item");
        this.setRegistryName("carryon", "entity_item");
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemEntity.hasEntityData(stack)) {
            return I18n.func_74838_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)new ResourceLocation(ItemEntity.getEntityName(stack))) + ".name"));
        }
        return "";
    }

    public static boolean hasEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74764_b(ENTITY_DATA_KEY) && tag.func_74764_b("entity");
        }
        return false;
    }

    public static boolean storeEntityData(@Nonnull Entity entity, World world, ItemStack stack) {
        NBTTagCompound tag;
        if (entity == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound entityData = new NBTTagCompound();
        entityData = entity.func_189511_e(entityData);
        String name = EntityList.func_191301_a((Entity)entity).toString();
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag.func_74764_b(ENTITY_DATA_KEY)) {
            return false;
        }
        tag.func_74782_a(ENTITY_DATA_KEY, (NBTBase)entityData);
        tag.func_74778_a("entity", name);
        stack.func_77982_d(tag);
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (ItemEntity.hasEntityData(stack)) {
            Entity entity;
            BlockPos finalPos = pos;
            if (!block.func_176200_f((IBlockAccess)world, pos)) {
                finalPos = pos.func_177972_a(facing);
            }
            if ((entity = ItemEntity.getEntity(stack, world)) != null) {
                if (!world.field_72995_K) {
                    entity.func_70080_a((double)finalPos.func_177958_n() + 0.5, (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p() + 0.5, 180.0f + player.field_70759_as, 0.0f);
                    world.func_72838_d(entity);
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).func_70642_aH();
                    }
                    ItemEntity.clearEntityData(stack);
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    CarryOn.network.sendToAllAround((IMessage)new CarrySlotPacket(9, player.func_145782_y()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 256.0));
                }
                player.getEntityData().func_82580_o("overrideKey");
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemEntity.hasEntityData(stack)) {
            if (ItemEntity.getEntity(stack, world) == null) {
                stack = ItemStack.field_190927_a;
            }
            if (entity instanceof EntityLivingBase) {
                if (!(entity instanceof EntityPlayer && CarryOnConfig.settings.slownessInCreative || !((EntityPlayer)entity).func_184812_l_())) {
                    return;
                }
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1, this.potionLevel(stack, world), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static void clearEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_82580_o(ENTITY_DATA_KEY);
            tag.func_82580_o("entity");
        }
    }

    public static NBTTagCompound getEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74775_l(ENTITY_DATA_KEY);
        }
        return null;
    }

    public static Entity getEntity(ItemStack stack, World world) {
        if (world == null) {
            return null;
        }
        String name = ItemEntity.getEntityName(stack);
        NBTTagCompound e = ItemEntity.getEntityData(stack);
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(name), (World)world);
        if (entity != null) {
            entity.func_70020_e(e);
        }
        return entity;
    }

    public static String getEntityName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74779_i("entity");
        }
        return null;
    }

    public static String getCustomName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("CustomName") && !tag.func_74779_i("CustomName").isEmpty()) {
                return tag.toString();
            }
            return tag.toString();
        }
        return null;
    }

    private int potionLevel(ItemStack stack, World world) {
        Entity e = ItemEntity.getEntity(stack, world);
        if (e == null) {
            return 1;
        }
        int i = (int)(e.field_70131_O * e.field_70130_N);
        if (i > 4) {
            i = 4;
        }
        if (!CarryOnConfig.settings.heavyEntities) {
            i = 1;
        }
        return (int)((double)i * CarryOnConfig.settings.entitySlownessMultiplier);
    }
}

