/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import tschipp.carryon.CarryOn;
import tschipp.carryon.common.config.CarryOnConfig;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.network.client.CarrySlotPacket;

public class ItemTile
extends Item {
    public static final String TILE_DATA_KEY = "tileData";

    public ItemTile() {
        this.func_77655_b("tile_item");
        this.setRegistryName("carryon", "tile_item");
        GameRegistry.register((IForgeRegistryEntry)this);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        if (ItemTile.hasTileData(stack)) {
            NBTTagCompound nbt;
            IBlockState state = ItemTile.getBlockState(stack);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, nbt = ItemTile.getTileData(stack))) {
                Object override = ModelOverridesHandler.getOverrideObject(state, nbt);
                if (override instanceof ItemStack) {
                    return ((ItemStack)override).func_82833_r();
                }
                IBlockState ostate = (IBlockState)override;
                ItemStack itemstack = new ItemStack(ostate.func_177230_c().func_180660_a(ostate, field_77697_d, 0), 1, state.func_177230_c().func_180651_a(ostate));
                return itemstack.func_82833_r();
            }
            return ItemTile.getItemStack(stack).func_82833_r();
        }
        return "";
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        block11: {
            Block block = world.func_180495_p(pos).func_177230_c();
            ItemStack stack = player.func_184586_b(hand);
            if (ItemTile.hasTileData(stack)) {
                try {
                    boolean canPlace;
                    Vec3d vec = player.func_70040_Z();
                    EnumFacing facing2 = EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)0.0f, (float)((float)vec.field_72449_c));
                    BlockPos pos2 = pos;
                    Block containedblock = ItemTile.getBlock(stack);
                    int meta = ItemTile.getMeta(stack);
                    IBlockState containedstate = ItemTile.getBlockState(stack);
                    if (!world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2)) {
                        pos2 = pos.func_177972_a(facing);
                    }
                    if (world.func_180495_p(pos2).func_177230_c().func_176200_f((IBlockAccess)world, pos2) && containedblock != null && (canPlace = containedblock.func_176196_c(world, pos2)) && player.func_175151_a(pos, facing, stack) && world.func_190527_a(containedblock, pos2, false, facing, (Entity)null)) {
                        TileEntity tile;
                        boolean set = false;
                        for (IProperty prop : containedblock.func_176223_P().func_177227_a()) {
                            Object[] allowedValues = prop.func_177700_c().toArray();
                            if (prop instanceof PropertyDirection && this.equal(allowedValues, EnumFacing.field_176754_o)) {
                                world.func_175656_a(pos2, containedstate.func_177226_a(prop, (Comparable)(containedblock instanceof BlockStairs ? facing2 : facing2.func_176734_d())));
                                set = true;
                                continue;
                            }
                            if (!(prop instanceof PropertyDirection) || !this.equal(allowedValues, EnumFacing.field_82609_l)) continue;
                            facing2 = EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
                            world.func_175656_a(pos2, containedstate.func_177226_a(prop, (Comparable)facing2.func_176734_d()));
                            set = true;
                        }
                        if (!set) {
                            world.func_175656_a(pos2, containedstate);
                        }
                        if ((tile = world.func_175625_s(pos2)) != null) {
                            tile.func_145839_a(ItemTile.getTileData(stack));
                            tile.func_174878_a(pos2);
                        }
                        ItemTile.clearTileData(stack);
                        player.func_184185_a(containedblock.func_185467_w().func_185841_e(), 1.0f, 0.5f);
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                        player.getEntityData().func_82580_o("overrideKey");
                        CarryOn.network.sendToAllAround((IMessage)new CarrySlotPacket(9, player.func_145782_y()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 256.0));
                        return EnumActionResult.SUCCESS;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world == null || !world.field_72995_K) break block11;
                    CarryOn.LOGGER.info("Block: " + ItemTile.getBlock(stack));
                    CarryOn.LOGGER.info("BlockState: " + ItemTile.getBlockState(stack));
                    CarryOn.LOGGER.info("Meta: " + ItemTile.getMeta(stack));
                    CarryOn.LOGGER.info("ItemStack: " + ItemTile.getItemStack(stack));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemTile.getBlockState(stack), ItemTile.getTileData(stack))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemTile.getBlockState(stack), ItemTile.getTileData(stack)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemTile.getBlockState(stack))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemTile.getBlockState(stack)));
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error detected. Cannot place block. Execute \"/carryon clear\" to remove the item"));
                    TextComponentString s = new TextComponentString(TextFormatting.GOLD + "here");
                    s.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                    player.func_145747_a(new TextComponentString(TextFormatting.RED + "Please report this error ").func_150257_a((ITextComponent)s));
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemTile.hasTileData(stack)) {
            if (entity instanceof EntityLivingBase) {
                if (!(entity instanceof EntityPlayer && CarryOnConfig.settings.slownessInCreative || !((EntityPlayer)entity).func_184812_l_())) {
                    return;
                }
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 1, this.potionLevel(stack), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static boolean hasTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74764_b(TILE_DATA_KEY) && tag.func_74764_b("block") && tag.func_74764_b("meta") && tag.func_74764_b("stateid");
        }
        return false;
    }

    public static boolean storeTileData(@Nullable TileEntity tile, World world, BlockPos pos, IBlockState state, ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound chest = new NBTTagCompound();
        if (tile != null) {
            chest = tile.func_189515_b(chest);
        }
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag.func_74764_b(TILE_DATA_KEY)) {
            return false;
        }
        tag.func_74782_a(TILE_DATA_KEY, (NBTBase)chest);
        ItemStack drop = new ItemStack(state.func_177230_c().func_180660_a(state, field_77697_d, 0), 1, state.func_177230_c().func_180651_a(state));
        tag.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        tag.func_74768_a("meta", drop.func_77952_i());
        tag.func_74768_a("stateid", Block.func_176210_f((IBlockState)state));
        stack.func_77982_d(tag);
        return true;
    }

    public static void clearTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_82580_o(TILE_DATA_KEY);
            tag.func_82580_o("block");
            tag.func_82580_o("meta");
            tag.func_82580_o("stateid");
        }
    }

    public static NBTTagCompound getTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74775_l(TILE_DATA_KEY);
        }
        return null;
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_176220_d((int)id).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static int getMeta(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            int meta = tag.func_74762_e("meta");
            return meta;
        }
        return 0;
    }

    public static ItemStack getItemStack(ItemStack stack) {
        return new ItemStack(ItemTile.getBlock(stack), 1, ItemTile.getMeta(stack));
    }

    public static IBlockState getBlockState(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_176220_d((int)id);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static boolean isLocked(BlockPos pos, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.func_189515_b(tag);
            return tag.func_74764_b("Lock") ? !tag.func_74779_i("Lock").equals("") : false;
        }
        return false;
    }

    private boolean equal(Object[] a, Object[] b) {
        if (a.length != b.length) {
            return false;
        }
        List<Object> lA = Arrays.asList(a);
        List<Object> lB = Arrays.asList(b);
        return lA.containsAll(lB);
    }

    private int potionLevel(ItemStack stack) {
        String nbt = ItemTile.getTileData(stack).toString();
        int i = nbt.length() / 500;
        if (i > 4) {
            i = 4;
        }
        if (!CarryOnConfig.settings.heavyTiles) {
            i = 1;
        }
        return (int)((double)i * CarryOnConfig.settings.blockSlownessMultiplier);
    }
}

