/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.item.ItemEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class RenderEntityEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        float partialticks = event.getPartialTicks();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack)) {
            if (ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) {
                return;
            }
            Entity entity = ItemEntity.getEntity(stack, (World)world);
            if (entity != null) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialticks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialticks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialticks;
                entity.func_70107_b(d0, d1, d2);
                entity.field_70177_z = 0.0f;
                entity.field_70126_B = 0.0f;
                entity.func_70034_d(0.0f);
                float height = entity.field_70131_O;
                float width = entity.field_70130_N;
                GlStateManager.func_179094_E();
                GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)((double)(-height) - 0.1), (double)((double)width + 0.1));
                GlStateManager.func_179141_d();
                if (perspective == 0) {
                    RenderHelper.func_74519_b();
                    Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
                    CarryOnOverride carryOverride = ScriptChecker.getOverride((EntityPlayer)player);
                    if (carryOverride != null) {
                        Entity newEntity;
                        double[] translation = ScriptParseHelper.getXYZArray(carryOverride.getRenderTranslation());
                        double[] rotation = ScriptParseHelper.getXYZArray(carryOverride.getRenderRotation());
                        double[] scaled = ScriptParseHelper.getscaled(carryOverride.getRenderscaled());
                        String entityname = carryOverride.getRenderNameEntity();
                        if (entityname != null && (newEntity = EntityType.func_200714_a((World)world, (ResourceLocation)new ResourceLocation(entityname))) != null) {
                            NBTTagCompound nbttag = carryOverride.getRenderNBT();
                            if (nbttag != null) {
                                newEntity.deserializeNBT(nbttag);
                            }
                            entity = newEntity;
                            entity.func_70107_b(d0, d1, d2);
                            entity.field_70177_z = 0.0f;
                            entity.field_70126_B = 0.0f;
                            entity.func_70034_d(0.0f);
                        }
                        GlStateManager.func_179137_b((double)translation[0], (double)translation[1], (double)translation[2]);
                        GlStateManager.func_179114_b((float)((float)rotation[0]), (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)rotation[1]), (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)((float)rotation[2]), (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179139_a((double)scaled[0], (double)scaled[1], (double)scaled[2]);
                    }
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).field_70737_aN = 0;
                    }
                    this.renderEntityStatic(entity);
                    Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
                }
                GlStateManager.func_179118_c();
                GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
                GlStateManager.func_179121_F();
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_179090_x();
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                if (perspective == 0) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderEntityStatic(Entity entity) {
        if (entity.field_70173_aa == 0) {
            entity.field_70142_S = entity.field_70165_t;
            entity.field_70137_T = entity.field_70163_u;
            entity.field_70136_U = entity.field_70161_v;
        }
        float f = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B);
        int i = this.getBrightnessForRender(entity, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (entity.func_70027_ad()) {
            i = 0xF000F0;
        }
        int j = i % 65536;
        int k = i / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.setLightmapDisabled(false);
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, f, 0.0f, true);
        this.setLightmapDisabled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBrightnessForRender(Entity entity, EntityPlayer player) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v));
        if (entity.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(player.field_70163_u + (double)entity.func_70047_e())));
            return entity.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setLightmapDisabled(boolean disabled) {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        if (disabled) {
            GlStateManager.func_179090_x();
        } else {
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayer player = event.getEntityPlayer();
        event.getRenderer().func_177087_b();
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        float partialticks = event.getPartialRenderTick();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack)) {
            Entity entity = ItemEntity.getEntity(stack, (World)world);
            float rotation = 0.0f;
            rotation = player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityLivingBase ? -(player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialticks) : -(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialticks);
            if (entity != null) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialticks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialticks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialticks;
                double c0 = clientPlayer.field_70142_S + (clientPlayer.field_70165_t - clientPlayer.field_70142_S) * (double)partialticks;
                double c1 = clientPlayer.field_70137_T + (clientPlayer.field_70163_u - clientPlayer.field_70137_T) * (double)partialticks;
                double c2 = clientPlayer.field_70136_U + (clientPlayer.field_70161_v - clientPlayer.field_70136_U) * (double)partialticks;
                double xOffset = d0 - c0;
                double yOffset = d1 - c1;
                double zOffset = d2 - c2;
                float height = entity.field_70131_O;
                float width = entity.field_70130_N;
                float multiplier = height * width;
                entity.func_70107_b(c0, c1, c2);
                entity.field_70177_z = 0.0f;
                entity.field_70126_B = 0.0f;
                entity.func_70034_d(0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)zOffset);
                GlStateManager.func_179139_a((double)((double)(10.0f - multiplier) * 0.08), (double)((double)(10.0f - multiplier) * 0.08), (double)((double)(10.0f - multiplier) * 0.08));
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)((double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1));
                if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.3);
                }
                if (player.func_70093_af()) {
                    GlStateManager.func_179137_b((double)0.0, (double)-0.3, (double)0.0);
                }
                Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
                CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
                if (carryOverride != null) {
                    Entity newEntity;
                    double[] translation = ScriptParseHelper.getXYZArray(carryOverride.getRenderTranslation());
                    double[] rot = ScriptParseHelper.getXYZArray(carryOverride.getRenderRotation());
                    double[] scaled = ScriptParseHelper.getscaled(carryOverride.getRenderscaled());
                    String entityname = carryOverride.getRenderNameEntity();
                    if (entityname != null && (newEntity = EntityType.func_200714_a((World)world, (ResourceLocation)new ResourceLocation(entityname))) != null) {
                        NBTTagCompound nbttag = carryOverride.getRenderNBT();
                        if (nbttag != null) {
                            newEntity.deserializeNBT(nbttag);
                        }
                        entity = newEntity;
                        entity.func_70107_b(c0, c1, c2);
                        entity.field_70177_z = 0.0f;
                        entity.field_70126_B = 0.0f;
                        entity.func_70034_d(0.0f);
                    }
                    GlStateManager.func_179137_b((double)translation[0], (double)translation[1], (double)translation[2]);
                    GlStateManager.func_179114_b((float)((float)rot[0]), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)((float)rot[1]), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)((float)rot[2]), (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179139_a((double)scaled[0], (double)scaled[1], (double)scaled[2]);
                }
                if (entity instanceof EntityLiving) {
                    ((EntityLiving)entity).field_70737_aN = 0;
                }
                Minecraft.func_71410_x().func_175598_ae().func_188388_a(entity, 0.0f, false);
                Minecraft.func_71410_x().func_175598_ae().func_178633_a(true);
                GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
                GlStateManager.func_179121_F();
            }
        }
    }
}

