/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.model.ModelPlayer;
import net.minecraft.client.renderer.entity.model.ModelRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.helper.KeyboardCallbackWrapper;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.helper.ScrollCallbackWrapper;
import tschipp.carryon.common.helper.StringParser;
import tschipp.carryon.common.item.ItemEntity;
import tschipp.carryon.common.item.ItemTile;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.network.server.SyncKeybindPacket;

public class RenderEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onScroll(ScrollCallbackWrapper.MouseScrolledEvent event) {
        ItemStack stack;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!(player == null || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity || !ItemTile.hasTileData(stack) && !ItemEntity.hasEntityData(stack))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        EntityPlayer player = event.player;
        if (player != null && event.side == LogicalSide.CLIENT) {
            boolean keyPressed = CarryOnKeybinds.carryKey.func_151470_d();
            boolean playerKeyPressed = CarryOnKeybinds.isKeyPressed(player);
            if (keyPressed && !playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, true);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(true));
            } else if (!keyPressed && playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_70170_p.field_72995_K) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
                if (CarryOn.FINGERPRINT_VIOLATED) {
                    TextComponentString cf = new TextComponentString(TextFormatting.AQUA + "Curseforge" + TextFormatting.RED);
                    cf.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/carry-on"));
                    player.func_145747_a(new TextComponentString(TextFormatting.RED + "[CarryOn] WARNING! Invalid fingerprint detected! The Carry On mod file may have been tampered with! If you didn't download the file from ").func_150257_a((ITextComponent)cf).func_150258_a(TextFormatting.RED + " or through any kind of mod launcher, immediately delete the file and re-download it from ").func_150257_a((ITextComponent)cf));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() != null) {
            ItemStack stack;
            boolean inventory = event.getGui() instanceof GuiContainer;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && inventory && !(stack = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack))) {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                Minecraft.func_71410_x().field_71462_r = null;
                Minecraft.func_71410_x().field_71417_B.func_198034_i();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void inputEvent(KeyboardCallbackWrapper.KeyPressedEvent event) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int key = event.key;
        int scancode = event.scancode;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            if (!stack.func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack))) {
                if (settings.field_74316_C.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.field_186718_X.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.field_74322_I.func_197976_a(key, scancode)) {
                    event.setCanceled(true);
                }
                for (KeyBinding keyBind : settings.field_151456_ac) {
                    if (!keyBind.func_197976_a(key, scancode)) continue;
                    event.setCanceled(true);
                }
            }
            int current = player.field_71071_by.field_70461_c;
            if (player.getEntityData().func_74764_b("carrySlot") && player.getEntityData().func_74762_e("carrySlot") != current) {
                player.field_71071_by.field_70461_c = player.getEntityData().func_74762_e("carrySlot");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        int perspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        boolean f1 = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack) && perspective == 0 && !f1) {
            if (ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) {
                return;
            }
            Block block = ItemTile.getBlock(stack);
            NBTTagCompound tag = ItemTile.getTileData(stack);
            IBlockState state = ItemTile.getBlockState(stack);
            ItemStack tileStack = ItemTile.getItemStack(stack);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)2.5, (double)2.5, (double)2.5);
            GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)-1.0);
            GlStateManager.func_179147_l();
            if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)8.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            IBakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (World)world, (EntityPlayer)player) : (tileStack.func_190926_b() ? Minecraft.func_71410_x().func_175602_ab().func_184389_a(state) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileStack, (World)world, (EntityLivingBase)player));
            CarryOnOverride carryOverride = ScriptChecker.getOverride((EntityPlayer)player);
            if (carryOverride != null) {
                double[] translation = ScriptParseHelper.getXYZArray(carryOverride.getRenderTranslation());
                double[] rotation = ScriptParseHelper.getXYZArray(carryOverride.getRenderRotation());
                double[] scaled = ScriptParseHelper.getscaled(carryOverride.getRenderscaled());
                Block b = StringParser.getBlock(carryOverride.getRenderNameBlock());
                if (b != null) {
                    ItemStack s = new ItemStack((IItemProvider)b, 1);
                    s.func_77982_d(carryOverride.getRenderNBT());
                    model = Minecraft.func_71410_x().func_175599_af().func_184393_a(s, (World)world, (EntityLivingBase)player);
                }
                GlStateManager.func_179137_b((double)translation[0], (double)translation[1], (double)translation[2]);
                GlStateManager.func_179114_b((float)((float)rotation[0]), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rotation[1]), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rotation[2]), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)scaled[0], (double)scaled[1], (double)scaled[2]);
            }
            int i = this.getBrightnessForRender((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.setLightmapDisabled(false);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, tag)) {
                Object override = ModelOverridesHandler.getOverrideObject(state, tag);
                if (override instanceof ItemStack) {
                    Minecraft.func_71410_x().func_175599_af().func_180454_a((ItemStack)override, model);
                } else {
                    Minecraft.func_71410_x().func_175599_af().func_180454_a(tileStack.func_190926_b() ? stack : tileStack, model);
                }
            } else {
                Minecraft.func_71410_x().func_175599_af().func_180454_a(tileStack.func_190926_b() ? stack : tileStack, model);
            }
            this.setLightmapDisabled(true);
            if (perspective == 0) {
                event.setCanceled(true);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
            GlStateManager.func_179121_F();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getBrightnessForRender(EntityPlayer player) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v));
        if (player.field_70170_p.func_175667_e((BlockPos)blockpos$mutableblockpos)) {
            blockpos$mutableblockpos.func_185336_p(MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.func_70047_e())));
            return player.field_70170_p.func_175626_b((BlockPos)blockpos$mutableblockpos, 0);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setLightmapDisabled(boolean disabled) {
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        if (disabled) {
            GlStateManager.func_179090_x();
        } else {
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        float partialticks = event.getPartialRenderTick();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack)) {
            Block block = ItemTile.getBlock(stack);
            IBlockState state = ItemTile.getBlockState(stack);
            NBTTagCompound tag = ItemTile.getTileData(stack);
            ItemStack tileItem = ItemTile.getItemStack(stack);
            float rotation = 0.0f;
            rotation = player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityLivingBase ? -(player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialticks) : -(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialticks);
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialticks;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialticks;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialticks;
            double c0 = clientPlayer.field_70142_S + (clientPlayer.field_70165_t - clientPlayer.field_70142_S) * (double)partialticks;
            double c1 = clientPlayer.field_70137_T + (clientPlayer.field_70163_u - clientPlayer.field_70137_T) * (double)partialticks;
            double c2 = clientPlayer.field_70136_U + (clientPlayer.field_70161_v - clientPlayer.field_70136_U) * (double)partialticks;
            double xOffset = d0 - c0;
            double yOffset = d1 - c1;
            double zOffset = d2 - c2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)zOffset);
            GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
            GlStateManager.func_179147_l();
            if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)1.6, (double)0.65);
                if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.4);
                }
            } else {
                GlStateManager.func_179114_b((float)(rotation + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.0, (double)1.6, (double)-0.65);
                if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.4);
                }
            }
            if (player.func_70093_af()) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.3, (double)0.0);
            }
            IBakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (World)world, player) : (tileItem.func_190926_b() ? Minecraft.func_71410_x().func_175602_ab().func_184389_a(state) : Minecraft.func_71410_x().func_175599_af().func_184393_a(tileItem, (World)world, (EntityLivingBase)player));
            CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
            if (carryOverride != null) {
                double[] translation = ScriptParseHelper.getXYZArray(carryOverride.getRenderTranslation());
                double[] rot = ScriptParseHelper.getXYZArray(carryOverride.getRenderRotation());
                double[] scaled = ScriptParseHelper.getscaled(carryOverride.getRenderscaled());
                Block b = StringParser.getBlock(carryOverride.getRenderNameBlock());
                if (b != null) {
                    ItemStack s = new ItemStack((IItemProvider)b, 1);
                    s.func_77982_d(carryOverride.getRenderNBT());
                    model = Minecraft.func_71410_x().func_175599_af().func_184393_a(s, (World)world, (EntityLivingBase)player);
                }
                GlStateManager.func_179137_b((double)translation[0], (double)translation[1], (double)translation[2]);
                GlStateManager.func_179114_b((float)((float)rot[0]), (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rot[1]), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)((float)rot[2]), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)scaled[0], (double)scaled[1], (double)scaled[2]);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, tag)) {
                Object override = ModelOverridesHandler.getOverrideObject(state, tag);
                if (override instanceof ItemStack) {
                    Minecraft.func_71410_x().func_175599_af().func_180454_a((ItemStack)override, model);
                } else {
                    Minecraft.func_71410_x().func_175599_af().func_180454_a(tileItem.func_190926_b() ? stack : tileItem, model);
                }
            } else {
                Minecraft.func_71410_x().func_175599_af().func_180454_a(tileItem.func_190926_b() ? stack : tileItem, model);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179139_a((double)1.0, (double)1.0, (double)1.0);
            GlStateManager.func_179121_F();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEvent(RenderPlayerEvent.Post event) {
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue()) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate")) {
            EntityPlayer player = event.getEntityPlayer();
            EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
            float partialticks = event.getPartialRenderTick();
            ItemStack stack = player.func_184614_ca();
            if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack)) {
                ModelPlayer model = event.getRenderer().func_177087_b();
                float rotation = 0.0f;
                rotation = player.func_184187_bx() != null && player.func_184187_bx() instanceof EntityLivingBase ? player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialticks : player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialticks;
                AbstractClientPlayer aplayer = (AbstractClientPlayer)player;
                ResourceLocation skinLoc = aplayer.func_110306_p();
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialticks;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialticks;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialticks;
                double c0 = clientPlayer.field_70142_S + (clientPlayer.field_70165_t - clientPlayer.field_70142_S) * (double)partialticks;
                double c1 = clientPlayer.field_70137_T + (clientPlayer.field_70163_u - clientPlayer.field_70137_T) * (double)partialticks;
                double c2 = clientPlayer.field_70136_U + (clientPlayer.field_70161_v - clientPlayer.field_70136_U) * (double)partialticks;
                double xOffset = d0 - c0;
                double yOffset = d1 - c1;
                double zOffset = d2 - c2;
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)zOffset);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(skinLoc);
                CarryOnOverride overrider = ScriptChecker.getOverride(player);
                if (overrider != null) {
                    double[] rotLeft = null;
                    double[] rotRight = null;
                    if (overrider.getRenderRotationLeftArm() != null) {
                        rotLeft = ScriptParseHelper.getXYZArray(overrider.getRenderRotationLeftArm());
                    }
                    if (overrider.getRenderRotationRightArm() != null) {
                        rotRight = ScriptParseHelper.getXYZArray(overrider.getRenderRotationRightArm());
                    }
                    boolean renderRight = overrider.isRenderRightArm();
                    boolean renderLeft = overrider.isRenderLeftArm();
                    if (renderLeft && rotLeft != null) {
                        this.renderArmPost(model.field_178724_i, (float)rotLeft[0], (float)rotLeft[2], rotation, false, player.func_70093_af());
                        this.renderArmPost(model.field_178734_a, (float)rotLeft[0], (float)rotLeft[2], rotation, false, player.func_70093_af());
                    } else if (renderLeft) {
                        this.renderArmPost(model.field_178724_i, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, rotation, false, player.func_70093_af());
                        this.renderArmPost(model.field_178734_a, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, rotation, false, player.func_70093_af());
                    }
                    if (renderRight && rotRight != null) {
                        this.renderArmPost(model.field_178723_h, (float)rotRight[0], (float)rotRight[2], rotation, true, player.func_70093_af());
                        this.renderArmPost(model.field_178732_b, (float)rotRight[0], (float)rotRight[2], rotation, true, player.func_70093_af());
                    } else if (renderRight) {
                        this.renderArmPost(model.field_178723_h, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, rotation, true, player.func_70093_af());
                        this.renderArmPost(model.field_178732_b, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, rotation, true, player.func_70093_af());
                    }
                } else {
                    this.renderArmPost(model.field_178723_h, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, rotation, true, player.func_70093_af());
                    this.renderArmPost(model.field_178724_i, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, rotation, false, player.func_70093_af());
                    this.renderArmPost(model.field_178734_a, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, rotation, false, player.func_70093_af());
                    this.renderArmPost(model.field_178732_b, 2.0f + (player.func_70093_af() ? 0.0f : 0.2f) - (stack.func_77973_b() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.func_77973_b() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, rotation, true, player.func_70093_af());
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEvent(RenderPlayerEvent.Pre event) {
        EntityPlayer player;
        ItemStack stack;
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue()) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate") && (!(stack = (player = event.getEntityPlayer()).func_184614_ca()).func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemTile.hasTileData(stack) || stack.func_77973_b() == RegistrationHandler.itemEntity && ItemEntity.hasEntityData(stack))) {
            ModelPlayer model = event.getRenderer().func_177087_b();
            CarryOnOverride overrider = ScriptChecker.getOverride(player);
            if (overrider != null) {
                boolean renderRight = overrider.isRenderRightArm();
                boolean renderLeft = overrider.isRenderLeftArm();
                if (renderRight) {
                    this.renderArmPre(model.field_178723_h);
                    this.renderArmPre(model.field_178732_b);
                }
                if (renderLeft) {
                    this.renderArmPre(model.field_178724_i);
                    this.renderArmPre(model.field_178734_a);
                }
            } else {
                this.renderArmPre(model.field_178723_h);
                this.renderArmPre(model.field_178724_i);
                this.renderArmPre(model.field_178734_a);
                this.renderArmPre(model.field_178732_b);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderArmPost(ModelRenderer arm, float x, float z, float rotation, boolean right, boolean sneaking) {
        arm.field_78807_k = false;
        if (right) {
            arm.field_78798_e = -MathHelper.func_76126_a((float)((float)Math.toRadians(rotation))) * 4.75f;
            arm.field_78800_c = -MathHelper.func_76134_b((float)((float)Math.toRadians(rotation))) * 4.75f;
        } else {
            arm.field_78798_e = MathHelper.func_76126_a((float)((float)Math.toRadians(rotation))) * 4.75f;
            arm.field_78800_c = MathHelper.func_76134_b((float)((float)Math.toRadians(rotation))) * 4.75f;
        }
        arm.field_78797_d = !sneaking ? 20.0f : 15.0f;
        arm.field_78795_f = x;
        arm.field_78796_g = (float)(-Math.toRadians(rotation));
        arm.field_78808_h = z;
        arm.func_78791_b(0.0625f);
        arm.field_78797_d = 2.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderArmPre(ModelRenderer arm) {
        arm.field_78807_k = true;
    }

    public boolean handleMobends() {
        return true;
    }

    public static boolean isChest(Block block) {
        return block == Blocks.field_150486_ae || block == Blocks.field_150477_bB || block == Blocks.field_150447_bR;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static ModelPlayer getPlayerModel(AbstractClientPlayer player) {
        return RenderEvents.getRenderPlayer(player).func_177087_b();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void hideItems(RenderSpecificHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && (stack.func_77973_b() == RegistrationHandler.itemTile || stack.func_77973_b() == RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }
}

