/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import tschipp.carryon.common.config.Configs;

public class ListHandler {
    public static List<String> FORBIDDEN_TILES;
    public static List<String> FORBIDDEN_ENTITIES;
    public static List<String> ALLOWED_ENTITIES;
    public static List<String> ALLOWED_TILES;
    public static List<String> FORBIDDEN_STACKING;
    public static List<String> ALLOWED_STACKING;

    public static boolean isForbidden(Block block) {
        String name = block.getRegistryName().toString();
        if (FORBIDDEN_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String s : FORBIDDEN_TILES) {
            String[] filter;
            if (!s.contains("*") || !ListHandler.containsAll(name, filter = s.replace("*", ",").split(","))) continue;
            contains = true;
        }
        return contains;
    }

    public static boolean isForbidden(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        boolean contains = FORBIDDEN_ENTITIES.contains(name);
        return contains;
    }

    public static boolean isAllowed(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        boolean contains = ALLOWED_ENTITIES.contains(name);
        return contains;
    }

    public static boolean isStackingForbidden(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        boolean contains = FORBIDDEN_STACKING.contains(name);
        return contains;
    }

    public static boolean isStackingAllowed(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        boolean contains = ALLOWED_STACKING.contains(name);
        return contains;
    }

    public static boolean isAllowed(Block block) {
        String name = block.getRegistryName().toString();
        if (ALLOWED_TILES.contains(name)) {
            return true;
        }
        boolean contains = false;
        for (String s : ALLOWED_TILES) {
            String[] filter;
            if (!s.contains("*") || !ListHandler.containsAll(name, filter = s.replace("*", ",").split(","))) continue;
            contains = true;
        }
        return contains;
    }

    public static void initLists() {
        List forbidden = (List)Configs.Blacklist.forbiddenTiles.get();
        FORBIDDEN_TILES = new ArrayList<String>();
        for (int i = 0; i < forbidden.size(); ++i) {
            FORBIDDEN_TILES.add((String)forbidden.get(i));
        }
        List forbiddenEntity = (List)Configs.Blacklist.forbiddenEntities.get();
        FORBIDDEN_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < forbiddenEntity.size(); ++i) {
            if (((String)forbiddenEntity.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)forbiddenEntity.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    FORBIDDEN_ENTITIES.add(key.toString());
                }
            }
            FORBIDDEN_ENTITIES.add((String)forbiddenEntity.get(i));
        }
        List allowedEntities = (List)Configs.WhiteList.allowedEntities.get();
        ALLOWED_ENTITIES = new ArrayList<String>();
        for (int i = 0; i < allowedEntities.size(); ++i) {
            if (((String)allowedEntities.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)allowedEntities.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    ALLOWED_ENTITIES.add(key.toString());
                }
            }
            ALLOWED_ENTITIES.add((String)allowedEntities.get(i));
        }
        List allowedBlocks = (List)Configs.WhiteList.allowedBlocks.get();
        ALLOWED_TILES = new ArrayList<String>();
        for (int i = 0; i < allowedBlocks.size(); ++i) {
            ALLOWED_TILES.add((String)allowedBlocks.get(i));
        }
        List forbiddenStacking = (List)Configs.Blacklist.forbiddenStacking.get();
        FORBIDDEN_STACKING = new ArrayList<String>();
        for (int i = 0; i < forbiddenStacking.size(); ++i) {
            if (((String)forbiddenStacking.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)forbiddenStacking.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    FORBIDDEN_STACKING.add(key.toString());
                }
            }
            FORBIDDEN_STACKING.add((String)forbiddenStacking.get(i));
        }
        List allowedStacking = (List)Configs.WhiteList.allowedStacking.get();
        ALLOWED_STACKING = new ArrayList<String>();
        for (int i = 0; i < allowedStacking.size(); ++i) {
            if (((String)allowedStacking.get(i)).contains("*")) {
                ResourceLocation[] keys;
                String[] filter = ((String)allowedStacking.get(i)).replace("*", ",").split(",");
                for (ResourceLocation key : keys = ForgeRegistries.ENTITIES.getKeys().toArray(new ResourceLocation[0])) {
                    if (!ListHandler.containsAll(key.toString(), filter)) continue;
                    ALLOWED_STACKING.add(key.toString());
                }
            }
            ALLOWED_STACKING.add((String)allowedStacking.get(i));
        }
    }

    public static boolean containsAll(String str, String ... strings) {
        boolean containsAll = true;
        for (String s : strings) {
            if (str.contains(s)) continue;
            containsAll = false;
        }
        return containsAll;
    }
}

