/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.handler;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.item.ItemTile;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;

public class PickupHandler {
    public static boolean canPlayerPickUpBlock(EntityPlayer player, @Nullable TileEntity tile, World world, BlockPos pos) {
        block12: {
            double distance;
            CarryOnOverride override;
            IBlockState state = world.func_180495_p(pos);
            NBTTagCompound tag = new NBTTagCompound();
            if (tile != null) {
                tile.func_189515_b(tag);
            }
            if ((override = ScriptChecker.inspectBlock(world.func_180495_p(pos), world, pos, tag)) != null) {
                return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
            }
            if ((Boolean)Configs.Settings.useWhitelistBlocks.get() != false ? !ListHandler.isAllowed(world.func_180495_p(pos).func_177230_c()) : ListHandler.isForbidden(world.func_180495_p(pos).func_177230_c())) {
                return false;
            }
            if ((state.func_185887_b((IBlockReader)world, pos) != -1.0f || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0) && !ItemTile.isLocked(pos, world)) {
                if (CustomPickupOverrideHandler.hasSpecialPickupConditions(state)) {
                    try {
                        Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                        Class<?> iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                        Method getPlayerData = ObfuscationReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", (Class[])new Class[]{EntityPlayer.class});
                        Method hasStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasStage", (Class[])new Class[]{String.class});
                        Object stageData = getPlayerData.invoke(null, player);
                        String condition = CustomPickupOverrideHandler.getPickupCondition(state);
                        boolean has = (Boolean)hasStage.invoke(stageData, condition);
                        if (has) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        try {
                            Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                            Class<?> iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                            Method getStageData = ObfuscationReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", (Class[])new Class[]{EntityPlayer.class});
                            Method hasUnlockedStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", (Class[])new Class[]{String.class});
                            Object stageData = getStageData.invoke(null, player);
                            String condition = CustomPickupOverrideHandler.getPickupCondition(state);
                            boolean has = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                            }
                            break block12;
                        }
                        catch (Exception ex) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                        }
                    }
                }
                if (((Boolean)Configs.Settings.pickupAllBlocks.get()).booleanValue() || tile != null) {
                    return PickupHandler.handleProtections((EntityPlayerMP)player, world, pos, state);
                }
            }
        }
        return false;
    }

    public static boolean canPlayerPickUpEntity(EntityPlayer player, Entity toPickUp) {
        block23: {
            double distance;
            boolean has;
            String condition;
            Object stageData;
            Class<?> iStageData;
            BlockPos pos;
            block22: {
                EntityAgeable living;
                pos = toPickUp.func_180425_c();
                if (toPickUp instanceof EntityPlayer) {
                    return false;
                }
                CarryOnOverride override = ScriptChecker.inspectEntity(toPickUp);
                if (override != null) {
                    return ScriptChecker.fulfillsConditions(override, player) && PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
                if (toPickUp instanceof EntityAgeable && ((Boolean)Configs.Settings.allowBabies.get()).booleanValue() && ((living = (EntityAgeable)toPickUp).func_70874_b() < 0 || living.func_70631_g_())) {
                    EntityTameable tame;
                    double distance2 = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v);
                    if (distance2 < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0) && toPickUp instanceof EntityTameable && (tame = (EntityTameable)toPickUp).func_184753_b() != null && tame.func_184753_b() != EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())) {
                        return false;
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                        try {
                            Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                            iStageData = Class.forName("net.darkhax.gamestages.data.IStageData");
                            Method getPlayerData = ObfuscationReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", (Class[])new Class[]{EntityPlayer.class});
                            Method hasStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasStage", (Class[])new Class[]{String.class});
                            stageData = getPlayerData.invoke(null, player);
                            condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                            has = (Boolean)hasStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                            break block22;
                        }
                        catch (Exception e) {
                            try {
                                Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                                Class<?> iStageData2 = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                                Method getStageData = ObfuscationReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", (Class[])new Class[]{EntityPlayer.class});
                                Method hasUnlockedStage = ObfuscationReflectionHelper.findMethod(iStageData2, (String)"hasUnlockedStage", (Class[])new Class[]{String.class});
                                Object stageData2 = getStageData.invoke(null, player);
                                String condition2 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                                boolean has2 = (Boolean)hasUnlockedStage.invoke(stageData2, condition2);
                                if (has2) {
                                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                                }
                                break block22;
                            }
                            catch (Exception ex) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                        }
                    }
                    return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                }
            }
            if ((Boolean)Configs.Settings.useWhitelistEntities.get() != false ? !ListHandler.isAllowed(toPickUp) : ListHandler.isForbidden(toPickUp)) {
                return false;
            }
            if ((((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && (((Boolean)Configs.Settings.pickupHostileMobs.get()).booleanValue() || !toPickUp.isCreatureType(EnumCreatureType.MONSTER, false) || player.func_184812_l_()) && ((double)toPickUp.field_70131_O <= (Double)Configs.Settings.maxEntityHeight.get() && (double)toPickUp.field_70130_N <= (Double)Configs.Settings.maxEntityWidth.get() || player.func_184812_l_()) && (distance = pos.func_177957_d(player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v)) < Math.pow((Double)Configs.Settings.maxDistance.get(), 2.0)) {
                if (toPickUp instanceof EntityTameable) {
                    EntityTameable tame = (EntityTameable)toPickUp;
                    UUID owner = tame.func_184753_b();
                    UUID playerID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    if (owner != null && !owner.equals(playerID)) {
                        return false;
                    }
                }
                if (CustomPickupOverrideHandler.hasSpecialPickupConditions(toPickUp)) {
                    try {
                        Class<?> gameStageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
                        Class<?> iStageData3 = Class.forName("net.darkhax.gamestages.data.IStageData");
                        Method getPlayerData = ObfuscationReflectionHelper.findMethod(gameStageHelper, (String)"getPlayerData", (Class[])new Class[]{EntityPlayer.class});
                        Method hasStage = ObfuscationReflectionHelper.findMethod(iStageData3, (String)"hasStage", (Class[])new Class[]{String.class});
                        Object stageData3 = getPlayerData.invoke(null, player);
                        String condition3 = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                        boolean has3 = (Boolean)hasStage.invoke(stageData3, condition3);
                        if (has3) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        try {
                            Class<?> playerDataHandler = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler");
                            iStageData = Class.forName("net.darkhax.gamestages.capabilities.PlayerDataHandler$IStageData");
                            Method getStageData = ObfuscationReflectionHelper.findMethod(playerDataHandler, (String)"getStageData", (Class[])new Class[]{EntityPlayer.class});
                            Method hasUnlockedStage = ObfuscationReflectionHelper.findMethod(iStageData, (String)"hasUnlockedStage", (Class[])new Class[]{String.class});
                            stageData = getStageData.invoke(null, player);
                            condition = CustomPickupOverrideHandler.getPickupCondition(toPickUp);
                            has = (Boolean)hasUnlockedStage.invoke(stageData, condition);
                            if (has) {
                                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                            }
                            break block23;
                        }
                        catch (Exception ex) {
                            return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
                        }
                    }
                }
                return PickupHandler.handleProtections((EntityPlayerMP)player, toPickUp);
            }
        }
        return false;
    }

    private static boolean handleProtections(EntityPlayerMP player, World world, BlockPos pos, IBlockState state) {
        boolean breakable = true;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            breakable = false;
        }
        return breakable;
    }

    private static boolean handleProtections(EntityPlayerMP player, Entity entity) {
        boolean canPickup = true;
        AttackEntityEvent event = new AttackEntityEvent((EntityPlayer)player, entity);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            canPickup = false;
        }
        return canPickup;
    }
}

