/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWKeyCallback;

public class KeyboardCallbackWrapper {
    GLFWKeyCallback oldCallback;

    public void setup(Minecraft mc) {
        this.oldCallback = GLFW.glfwSetKeyCallback((long)mc.field_195558_d.func_198092_i(), this::keyCallback);
    }

    private void keyCallback(long window, int key, int scancode, int action, int mods) {
        KeyPressedEvent event = new KeyPressedEvent(key, scancode);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        if (this.oldCallback != null) {
            this.oldCallback.invoke(window, key, scancode, action, mods);
        }
    }

    @Cancelable
    public static class KeyPressedEvent
    extends Event {
        public int key;
        public int scancode;

        public KeyPressedEvent(int key, int scancode) {
            this.key = key;
            this.scancode = scancode;
        }
    }
}

