/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.helper;

import com.mojang.brigadier.StringReader;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.command.arguments.ItemParser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IItemProvider;
import tschipp.carryon.common.helper.InvalidConfigException;

public class StringParser {
    @Nullable
    public static Block getBlock(String string) {
        IBlockState state = StringParser.getBlockState(string);
        if (state != null) {
            return state.func_177230_c();
        }
        return null;
    }

    @Nullable
    public static IBlockState getBlockState(String string) {
        if (string == null) {
            return null;
        }
        BlockStateParser parser = new BlockStateParser(new StringReader(string), false);
        try {
            parser.func_197243_a(false);
            return parser.func_197249_b();
        }
        catch (Exception e) {
            new InvalidConfigException("Blockstate parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return null;
        }
    }

    @Nullable
    public static Item getItem(String string) {
        if (string == null) {
            return null;
        }
        ItemParser parser = new ItemParser(new StringReader(string), false);
        try {
            parser.func_197327_f();
            return parser.func_197326_b();
        }
        catch (Exception e) {
            new InvalidConfigException("Item parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return null;
        }
    }

    public static ItemStack getItemStack(String string) {
        if (string == null) {
            return null;
        }
        ItemParser parser = new ItemParser(new StringReader(string), false);
        try {
            parser.func_197327_f();
            Item item = parser.func_197326_b();
            NBTTagCompound nbt = parser.func_197325_c();
            ItemStack stack = new ItemStack((IItemProvider)item, 1);
            if (nbt != null) {
                stack.func_77982_d(nbt);
            }
            return stack;
        }
        catch (Exception e) {
            new InvalidConfigException("Item parsing Exception at: " + string + " : " + e.getMessage()).printException();
            return ItemStack.field_190927_a;
        }
    }

    @Nullable
    public static NBTTagCompound getTagCompound(String string) {
        NBTTagCompound tag = null;
        if (string == null) {
            return null;
        }
        if (string.contains("{")) {
            if (!string.contains("}")) {
                new InvalidConfigException("Missing } at  : " + string).printException();
            }
            String nbt = string.substring(string.indexOf("{"));
            string = string.replace(nbt, "");
            try {
                tag = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (Exception e) {
                new InvalidConfigException("Error while parsing NBT: " + e.getMessage()).printException();
                return null;
            }
        } else if (string.contains("}")) {
            new InvalidConfigException("Missing { at  : " + string).printException();
        }
        return tag;
    }
}

