/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;

public class ItemEntity
extends Item {
    public static final String ENTITY_DATA_KEY = "entityData";

    public ItemEntity() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName("carryon", "entity_item");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (ItemEntity.hasEntityData(stack)) {
            return new TextComponentTranslation(ItemEntity.getEntityType(stack).func_210760_d(), new Object[0]);
        }
        return new TextComponentString("");
    }

    public static boolean hasEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74764_b(ENTITY_DATA_KEY) && tag.func_74764_b("entity");
        }
        return false;
    }

    public static boolean storeEntityData(@Nonnull Entity entity, World world, ItemStack stack) {
        NBTTagCompound tag;
        if (entity == null) {
            return false;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound entityData = new NBTTagCompound();
        entityData = entity.serializeNBT();
        String name = EntityType.func_200718_a((EntityType)entity.func_200600_R()).toString();
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag.func_74764_b(ENTITY_DATA_KEY)) {
            return false;
        }
        tag.func_74782_a(ENTITY_DATA_KEY, (INBTBase)entityData);
        tag.func_74778_a("entity", name);
        stack.func_77982_d(tag);
        return true;
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        EntityPlayer player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        EnumFacing facing = context.func_196000_l();
        ItemStack stack = context.func_195996_i();
        IBlockState state = world.func_180495_p(pos);
        if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
            return EnumActionResult.FAIL;
        }
        if (ItemEntity.hasEntityData(stack)) {
            Entity entity;
            BlockPos finalPos = pos;
            if (!state.func_196953_a(new BlockItemUseContext(context))) {
                finalPos = pos.func_177972_a(facing);
            }
            if ((entity = ItemEntity.getEntity(stack, world)) != null) {
                if (!world.field_72995_K) {
                    entity.func_70080_a((double)finalPos.func_177958_n() + 0.5, (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p() + 0.5, 180.0f + player.field_70759_as, 0.0f);
                    world.func_72838_d(entity);
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).func_70642_aH();
                    }
                    ItemEntity.clearEntityData(stack);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    ItemEvents.sendPacket(player, 9, 0);
                }
                player.getEntityData().func_82580_o("overrideKey");
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemEntity.hasEntityData(stack)) {
            if (ItemEntity.getEntity(stack, world) == null) {
                stack = ItemStack.field_190927_a;
            }
            if (entity instanceof EntityLivingBase) {
                if (!(entity instanceof EntityPlayer && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((EntityPlayer)entity).func_184812_l_())) {
                    return;
                }
                ((EntityLivingBase)entity).func_195064_c(new PotionEffect(MobEffects.field_76421_d, 1, this.potionLevel(stack, world), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static void clearEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_82580_o(ENTITY_DATA_KEY);
            tag.func_82580_o("entity");
        }
    }

    public static NBTTagCompound getEntityData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74775_l(ENTITY_DATA_KEY);
        }
        return null;
    }

    public static Entity getEntity(ItemStack stack, World world) {
        if (world == null) {
            return null;
        }
        String name = ItemEntity.getEntityName(stack);
        NBTTagCompound e = ItemEntity.getEntityData(stack);
        Entity entity = EntityType.func_200714_a((World)world, (ResourceLocation)new ResourceLocation(name));
        if (entity != null) {
            entity.deserializeNBT(e);
        }
        return entity;
    }

    public static String getEntityName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74779_i("entity");
        }
        return null;
    }

    public static String getCustomName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("CustomName") && !tag.func_74779_i("CustomName").isEmpty()) {
                return tag.toString();
            }
            return tag.toString();
        }
        return null;
    }

    public static EntityType<?> getEntityType(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            String name = tag.func_74779_i("entity");
            EntityType type = EntityType.func_200713_a((String)name);
            return type;
        }
        return null;
    }

    private int potionLevel(ItemStack stack, World world) {
        Entity e = ItemEntity.getEntity(stack, world);
        if (e == null) {
            return 1;
        }
        int i = (int)(e.field_70131_O * e.field_70130_N);
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyEntities.get()).booleanValue()) {
            i = 1;
        }
        double multiplier = (Double)Configs.Settings.entitySlownessMultiplier.get();
        return (int)(multiplier * (double)i);
    }
}

