/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.item;

import com.google.common.base.CharMatcher;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.event.ItemEvents;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ModelOverridesHandler;

public class ItemTile
extends Item {
    public static final String TILE_DATA_KEY = "tileData";
    public static final String[] FACING_KEYS = new String[]{"rotation", "rot", "facing", "face", "direction", "dir", "front", "forward"};

    public ItemTile() {
        super(new Item.Properties().func_200917_a(1));
        this.setRegistryName("carryon", "tile_item");
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (ItemTile.hasTileData(stack)) {
            NBTTagCompound nbt;
            IBlockState state = ItemTile.getBlockState(stack);
            if (ModelOverridesHandler.hasCustomOverrideModel(state, nbt = ItemTile.getTileData(stack))) {
                Object override = ModelOverridesHandler.getOverrideObject(state, nbt);
                if (override instanceof ItemStack) {
                    return ((ItemStack)override).func_200301_q();
                }
                IBlockState ostate = (IBlockState)override;
                return ostate.func_177230_c().func_200291_n();
            }
            return ItemTile.getItemStack(stack).func_200301_q();
        }
        return new TextComponentString("");
    }

    public EnumActionResult func_195939_a(ItemUseContext context) {
        block18: {
            EnumFacing facing = context.func_196000_l();
            EntityPlayer player = context.func_195999_j();
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            ItemStack stack = context.func_195996_i();
            if (ModList.get().isLoaded("betterplacement") && CarryOnKeybinds.isKeyPressed(player)) {
                return EnumActionResult.FAIL;
            }
            if (ItemTile.hasTileData(stack)) {
                try {
                    boolean canPlace;
                    Vec3d vec = player.func_70040_Z();
                    EnumFacing facing2 = EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)0.0f, (float)((float)vec.field_72449_c));
                    BlockPos pos2 = pos;
                    Block containedblock = ItemTile.getBlock(stack);
                    IBlockState containedstate = ItemTile.getBlockState(stack);
                    if (!world.func_180495_p(pos2).func_196953_a(new BlockItemUseContext(context))) {
                        pos2 = pos.func_177972_a(facing);
                    }
                    if (world.func_180495_p(pos2).func_196953_a(new BlockItemUseContext(context)) && containedblock != null && (canPlace = containedstate.func_196955_c((IWorldReaderBase)world, pos2)) && player.func_175151_a(pos, facing, stack) && world.func_175660_a(player, pos2)) {
                        IBlockState actualState = containedblock.func_196258_a(new BlockItemUseContext(context));
                        BlockSnapshot snapshot = new BlockSnapshot(world, pos2, containedstate);
                        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(snapshot, world.func_180495_p(pos), player, EnumHand.MAIN_HAND);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.isCanceled()) {
                            TileEntity tile;
                            world.func_175656_a(pos2, actualState);
                            if (!ItemTile.getTileData(stack).isEmpty()) {
                                NBTTagCompound tag = ItemTile.getTileData(stack);
                                Set keys = tag.func_150296_c();
                                block7: for (String key : keys) {
                                    for (String facingKey : FACING_KEYS) {
                                        if (!key.toLowerCase().equals(facingKey)) continue;
                                        byte type = tag.func_150299_b(key);
                                        switch (type) {
                                            case 8: {
                                                tag.func_74778_a(key, CharMatcher.javaUpperCase().matchesAllOf((CharSequence)tag.func_74779_i(key)) ? facing2.func_176734_d().func_176610_l().toUpperCase() : facing2.func_176734_d().func_176610_l());
                                                break;
                                            }
                                            case 3: {
                                                tag.func_74768_a(key, facing2.func_176734_d().func_176745_a());
                                                break;
                                            }
                                            case 1: {
                                                tag.func_74774_a(key, (byte)facing2.func_176734_d().func_176745_a());
                                                break;
                                            }
                                        }
                                        break block7;
                                    }
                                }
                            }
                            if ((tile = world.func_175625_s(pos2)) != null) {
                                tile.deserializeNBT(ItemTile.getTileData(stack));
                                tile.func_174878_a(pos2);
                            }
                            ItemTile.clearTileData(stack);
                            player.func_184185_a(actualState.getSoundType((IWorldReader)world, pos2, (Entity)player).func_185841_e(), 1.0f, 0.5f);
                            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                            player.getEntityData().func_82580_o("overrideKey");
                            ItemEvents.sendPacket(player, 9, 0);
                            return EnumActionResult.SUCCESS;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (world == null || !world.field_72995_K) break block18;
                    CarryOn.LOGGER.info("Block: " + ItemTile.getBlock(stack));
                    CarryOn.LOGGER.info("BlockState: " + ItemTile.getBlockState(stack));
                    CarryOn.LOGGER.info("ItemStack: " + ItemTile.getItemStack(stack));
                    if (ModelOverridesHandler.hasCustomOverrideModel(ItemTile.getBlockState(stack), ItemTile.getTileData(stack))) {
                        CarryOn.LOGGER.info("Override Model: " + ModelOverridesHandler.getOverrideObject(ItemTile.getBlockState(stack), ItemTile.getTileData(stack)));
                    }
                    if (CustomPickupOverrideHandler.hasSpecialPickupConditions(ItemTile.getBlockState(stack))) {
                        CarryOn.LOGGER.info("Custom Pickup Condition: " + CustomPickupOverrideHandler.getPickupCondition(ItemTile.getBlockState(stack)));
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error detected. Cannot place block. Execute \"/carryon clear\" to remove the item"));
                    TextComponentString s = new TextComponentString(TextFormatting.GOLD + "here");
                    s.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                    player.func_145747_a(new TextComponentString(TextFormatting.RED + "Please report this error ").func_150257_a((ITextComponent)s));
                }
            }
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (ItemTile.hasTileData(stack)) {
            if (entity instanceof EntityLivingBase) {
                if (!(entity instanceof EntityPlayer && ((Boolean)Configs.Settings.slownessInCreative.get()).booleanValue() || !((EntityPlayer)entity).func_184812_l_())) {
                    return;
                }
                ((EntityLivingBase)entity).func_195064_c(new PotionEffect(MobEffects.field_76421_d, 1, this.potionLevel(stack), false, false));
            }
        } else {
            stack = ItemStack.field_190927_a;
        }
    }

    public static boolean hasTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74764_b(TILE_DATA_KEY) && tag.func_74764_b("block") && tag.func_74764_b("stateid");
        }
        return false;
    }

    public static boolean storeTileData(@Nullable TileEntity tile, World world, BlockPos pos, IBlockState state, ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_190926_b()) {
            return false;
        }
        NBTTagCompound chest = new NBTTagCompound();
        if (tile != null) {
            chest = tile.func_189515_b(chest);
        }
        NBTTagCompound nBTTagCompound = tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        if (tag.func_74764_b(TILE_DATA_KEY)) {
            return false;
        }
        tag.func_74782_a(TILE_DATA_KEY, (INBTBase)chest);
        tag.func_74778_a("block", state.func_177230_c().getRegistryName().toString());
        tag.func_74768_a("stateid", Block.func_196246_j((IBlockState)state));
        stack.func_77982_d(tag);
        return true;
    }

    public static void clearTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_82580_o(TILE_DATA_KEY);
            tag.func_82580_o("block");
            tag.func_82580_o("stateid");
        }
    }

    public static NBTTagCompound getTileData(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag.func_74775_l(TILE_DATA_KEY);
        }
        return null;
    }

    public static Block getBlock(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_196257_b((int)id).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static ItemStack getItemStack(ItemStack stack) {
        return new ItemStack((IItemProvider)ItemTile.getBlock(stack), 1);
    }

    public static IBlockState getBlockState(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            int id = tag.func_74762_e("stateid");
            return Block.func_196257_b((int)id);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static boolean isLocked(BlockPos pos, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            te.func_189515_b(tag);
            return tag.func_74764_b("Lock") ? !tag.func_74779_i("Lock").equals("") : false;
        }
        return false;
    }

    private int potionLevel(ItemStack stack) {
        String nbt = ItemTile.getTileData(stack).toString();
        int i = nbt.length() / 500;
        if (i > 4) {
            i = 4;
        }
        if (!((Boolean)Configs.Settings.heavyTiles.get()).booleanValue()) {
            i = 1;
        }
        return (int)((double)i * (Double)Configs.Settings.blockSlownessMultiplier.get());
    }
}

