/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.animation;

import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.client.animation.ClientChannel;
import com.leviathanstudio.craftstudio.client.animation.EnumAnimationMode;
import com.leviathanstudio.craftstudio.client.animation.KeyFrame;
import com.leviathanstudio.craftstudio.client.exception.CSResourceNotRegisteredException;
import com.leviathanstudio.craftstudio.client.json.CSReadedAnim;
import com.leviathanstudio.craftstudio.client.json.CSReadedAnimBlock;
import com.leviathanstudio.craftstudio.client.json.CSReadedModel;
import com.leviathanstudio.craftstudio.client.json.CSReadedModelBlock;
import com.leviathanstudio.craftstudio.client.util.MathHelper;
import java.util.Map;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CSAnimChannel
extends ClientChannel {
    private CSReadedAnim rAnim;
    private CSReadedModel rModel;

    public CSAnimChannel(ResourceLocation animIn, ResourceLocation modelIn, boolean looped) throws CSResourceNotRegisteredException {
        this(animIn, modelIn, 60.0f, looped);
    }

    public CSAnimChannel(ResourceLocation animIn, ResourceLocation modelIn, float fps, boolean looped) throws CSResourceNotRegisteredException {
        super(animIn.toString(), false);
        this.rAnim = (CSReadedAnim)GameRegistry.findRegistry(CSReadedAnim.class).getValue(animIn);
        if (this.rAnim == null) {
            throw new CSResourceNotRegisteredException(animIn.toString());
        }
        this.rModel = (CSReadedModel)GameRegistry.findRegistry(CSReadedModel.class).getValue(modelIn);
        if (this.rModel == null) {
            throw new CSResourceNotRegisteredException(modelIn.toString());
        }
        if (!this.rModel.isAnimable()) {
            CraftStudioApi.getLogger().warn("You are trying to animate the model \"" + modelIn.toString() + "\"");
            CraftStudioApi.getLogger().warn("But it contains at least two blocks with the name \"" + this.rModel.whyUnAnimable() + "\"");
            CraftStudioApi.getLogger().warn("There could be weird result with your animation");
        }
        this.fps = fps;
        this.totalFrames = this.rAnim.getDuration();
        if (looped) {
            this.setAnimationMode(EnumAnimationMode.LOOP);
        } else if (this.rAnim.isHoldLastK()) {
            this.setAnimationMode(EnumAnimationMode.HOLD);
        }
        this.initializeAllFrames();
    }

    @Override
    protected void initializeAllFrames() {
        Integer[] integerArray = this.rAnim.getKeyFrames();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            this.getKeyFrames().put(i2, new KeyFrame());
        }
        if (this.rAnim.isHoldLastK() && !this.getKeyFrames().containsKey(this.totalFrames)) {
            this.getKeyFrames().put(this.totalFrames, new KeyFrame());
        }
        for (CSReadedAnimBlock block : this.rAnim.getBlocks()) {
            CSReadedModelBlock mBlock = this.rModel.getBlockFromName(block.getName());
            int lastRK = 0;
            int lastTK = 0;
            int lastOK = 0;
            int lastSK = 0;
            if (mBlock != null) {
                for (Map.Entry<Integer, CSReadedAnimBlock.ReadedKeyFrame> entry : block.getKeyFrames().entrySet()) {
                    Vector3f vector;
                    KeyFrame keyFrame = this.getKeyFrames().get(entry.getKey());
                    CSReadedAnimBlock.ReadedKeyFrame rKeyFrame = entry.getValue();
                    if (rKeyFrame.position != null) {
                        vector = new Vector3f(rKeyFrame.position);
                        vector.add((Tuple3f)mBlock.getRotationPoint());
                        keyFrame.modelRenderersTranslations.put(block.getName(), vector);
                        if (lastTK < entry.getKey()) {
                            lastTK = entry.getKey();
                        }
                    }
                    if (rKeyFrame.rotation != null) {
                        vector = new Vector3f(rKeyFrame.rotation);
                        vector.add((Tuple3f)mBlock.getRotation());
                        keyFrame.modelRenderersRotations.put(block.getName(), MathHelper.quatFromEuler(vector));
                        if (lastRK < entry.getKey()) {
                            lastRK = entry.getKey();
                        }
                    }
                    if (rKeyFrame.offset != null) {
                        vector = new Vector3f(rKeyFrame.offset);
                        vector.add((Tuple3f)mBlock.getOffset());
                        keyFrame.modelRenderersOffsets.put(block.getName(), vector);
                        if (lastOK < entry.getKey()) {
                            lastOK = entry.getKey();
                        }
                    }
                    if (rKeyFrame.stretching == null) continue;
                    vector = new Vector3f(rKeyFrame.stretching);
                    vector.add((Tuple3f)mBlock.getStretch());
                    keyFrame.modelRenderersStretchs.put(block.getName(), vector);
                    if (lastSK >= entry.getKey()) continue;
                    lastSK = entry.getKey();
                }
            } else {
                System.out.println("The block " + block.getName() + " doesn't exist in model " + this.rModel.getName() + " !");
            }
            if (!this.rAnim.isHoldLastK()) continue;
            if (lastTK != 0) {
                this.getKeyFrames().get((Object)Integer.valueOf((int)this.totalFrames)).modelRenderersTranslations.put(block.getName(), this.getKeyFrames().get((Object)Integer.valueOf((int)lastTK)).modelRenderersTranslations.get(block.getName()));
            }
            if (lastRK != 0) {
                this.getKeyFrames().get((Object)Integer.valueOf((int)this.totalFrames)).modelRenderersRotations.put(block.getName(), this.getKeyFrames().get((Object)Integer.valueOf((int)lastRK)).modelRenderersRotations.get(block.getName()));
            }
            if (lastOK != 0) {
                this.getKeyFrames().get((Object)Integer.valueOf((int)this.totalFrames)).modelRenderersOffsets.put(block.getName(), this.getKeyFrames().get((Object)Integer.valueOf((int)lastOK)).modelRenderersOffsets.get(block.getName()));
            }
            if (lastSK == 0) continue;
            this.getKeyFrames().get((Object)Integer.valueOf((int)this.totalFrames)).modelRenderersStretchs.put(block.getName(), this.getKeyFrames().get((Object)Integer.valueOf((int)lastSK)).modelRenderersStretchs.get(block.getName()));
        }
    }
}

