/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.client.model;

import com.leviathanstudio.craftstudio.client.animation.ClientAnimationHandler;
import com.leviathanstudio.craftstudio.client.exception.CSResourceNotRegisteredException;
import com.leviathanstudio.craftstudio.client.json.CSReadedModel;
import com.leviathanstudio.craftstudio.client.json.CSReadedModelBlock;
import com.leviathanstudio.craftstudio.client.model.CSModelBox;
import com.leviathanstudio.craftstudio.client.model.CSModelRenderer;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCraftStudio
extends ModelBase {
    private List<CSModelRenderer> parentBlocks = new ArrayList<CSModelRenderer>();

    public ModelCraftStudio(String modid, String modelNameIn, int textureSize) {
        this(modid, modelNameIn, textureSize, textureSize);
    }

    public ModelCraftStudio(String modid, String modelNameIn, int textureWidth, int textureHeight) {
        this(new ResourceLocation(modid, modelNameIn), textureWidth, textureHeight);
    }

    private ModelCraftStudio(ResourceLocation modelIn, int textureWidth, int textureHeight) {
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
        CSReadedModel rModel = (CSReadedModel)GameRegistry.findRegistry(CSReadedModel.class).getValue(modelIn);
        if (rModel == null) {
            throw new CSResourceNotRegisteredException(modelIn.toString());
        }
        for (CSReadedModelBlock rBlock : rModel.getParents()) {
            CSModelRenderer modelRend = this.generateCSModelRend(rBlock);
            this.parentBlocks.add(modelRend);
            this.generateChild(rBlock, modelRend);
        }
    }

    private void generateChild(CSReadedModelBlock rParent, CSModelRenderer parent) {
        for (CSReadedModelBlock rBlock : rParent.getChilds()) {
            CSModelRenderer modelRend = this.generateCSModelRend(rBlock);
            parent.func_78792_a(modelRend);
            this.generateChild(rBlock, modelRend);
        }
    }

    private CSModelRenderer generateCSModelRend(CSReadedModelBlock rBlock) {
        CSModelRenderer modelRend = new CSModelRenderer(this, rBlock.getName(), rBlock.getTexOffset()[0], rBlock.getTexOffset()[1]);
        if (rBlock.getVertex() != null) {
            PositionTextureVertex[] vertices = new PositionTextureVertex[8];
            for (int i = 0; i < 8; ++i) {
                vertices[i] = new PositionTextureVertex(rBlock.getVertex()[i][0], rBlock.getVertex()[i][1], rBlock.getVertex()[i][2], 0.0f, 0.0f);
            }
            modelRend.addBox(vertices, CSModelBox.getTextureUVsForRect(rBlock.getTexOffset()[0], rBlock.getTexOffset()[1], rBlock.getSize().x, rBlock.getSize().y, rBlock.getSize().z));
        } else {
            modelRend.addBox(-rBlock.getSize().x / 2.0f, -rBlock.getSize().y / 2.0f, -rBlock.getSize().z / 2.0f, rBlock.getSize().x, rBlock.getSize().y, rBlock.getSize().z);
        }
        modelRend.setDefaultRotationPoint(rBlock.getRotationPoint().x, rBlock.getRotationPoint().y, rBlock.getRotationPoint().z);
        modelRend.setInitialRotationMatrix(rBlock.getRotation().x, rBlock.getRotation().y, rBlock.getRotation().z);
        modelRend.setDefaultOffset(rBlock.getOffset().x, rBlock.getOffset().y, rBlock.getOffset().z);
        modelRend.setDefaultStretch(rBlock.getStretch().x, rBlock.getStretch().y, rBlock.getStretch().z);
        modelRend.func_78787_b(this.field_78090_t, this.field_78089_u);
        return modelRend;
    }

    public void render(TileEntity tileEntityIn) {
        float modelScale = 0.0625f;
        ClientAnimationHandler.performAnimationInModel(this.parentBlocks, (IAnimated)tileEntityIn);
        for (CSModelRenderer block : this.parentBlocks) {
            block.func_78785_a(modelScale);
        }
    }

    public void render() {
        float modelScale = 0.0625f;
        for (CSModelRenderer block : this.parentBlocks) {
            block.func_78785_a(modelScale);
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        ClientAnimationHandler.performAnimationInModel(this.parentBlocks, (IAnimated)entityIn);
        for (CSModelRenderer block : this.parentBlocks) {
            block.func_78785_a(scale);
        }
    }

    public static CSModelRenderer getModelRendererFromNameAndBlock(String name, CSModelRenderer block) {
        if (block.field_78802_n.equals(name)) {
            return block;
        }
        for (ModelRenderer child : block.field_78805_m) {
            CSModelRenderer childModel;
            CSModelRenderer result;
            if (!(child instanceof CSModelRenderer) || (result = ModelCraftStudio.getModelRendererFromNameAndBlock(name, childModel = (CSModelRenderer)child)) == null) continue;
            return result;
        }
        return null;
    }

    public CSModelRenderer getModelRendererFromName(String name) {
        for (CSModelRenderer parent : this.parentBlocks) {
            CSModelRenderer result = ModelCraftStudio.getModelRendererFromNameAndBlock(name, parent);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public List<CSModelRenderer> getParentBlocks() {
        return this.parentBlocks;
    }
}

