/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio.common.network;

import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.common.animation.IAnimated;
import com.leviathanstudio.craftstudio.common.network.EnumIAnimatedEvent;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class IAnimatedEventMessage
implements IMessage {
    public short event;
    public short animId;
    public short optAnimId = (short)-1;
    public float keyframeInfo = -1.0f;
    public IAnimated animated;
    public long most;
    public long least;
    public int x;
    public int y;
    public int z;
    public boolean hasEntity;

    public IAnimatedEventMessage() {
    }

    public IAnimatedEventMessage(EnumIAnimatedEvent event, IAnimated animated, short animId) {
        if (event != null) {
            this.event = event.getId();
        }
        this.animated = animated;
        this.animId = animId;
    }

    public IAnimatedEventMessage(EnumIAnimatedEvent event, IAnimated animated, short animId, float keyframeInfo) {
        this(event, animated, animId);
        this.keyframeInfo = keyframeInfo;
    }

    public IAnimatedEventMessage(EnumIAnimatedEvent event, IAnimated animated, short animId, float keyframeInfo, short optAnimId) {
        this(event, animated, animId, keyframeInfo);
        this.optAnimId = optAnimId;
    }

    public IAnimatedEventMessage(IAnimatedEventMessage eventObj) {
        this(null, eventObj.animated, eventObj.animId, eventObj.keyframeInfo, eventObj.optAnimId);
        this.event = eventObj.event;
    }

    public void fromBytes(ByteBuf buf) {
        short actualEvent = buf.readShort();
        if (actualEvent < 0 || actualEvent >= 8) {
            this.event = (short)-1;
            CraftStudioApi.getLogger().error("Networking error : invalid packet.");
            return;
        }
        if (actualEvent < 4) {
            this.most = buf.readLong();
            this.least = buf.readLong();
            this.event = actualEvent;
            this.hasEntity = true;
        } else {
            this.x = buf.readInt();
            this.y = buf.readInt();
            this.z = buf.readInt();
            this.event = (short)(actualEvent - 4);
            this.hasEntity = false;
        }
        this.animId = buf.readShort();
        if (this.event != 2) {
            this.keyframeInfo = buf.readFloat();
        }
        if (this.event > 2) {
            this.optAnimId = buf.readShort();
        }
    }

    public void toBytes(ByteBuf buf) {
        if (this.event < 0 || this.event >= 4) {
            buf.writeShort(-1);
            CraftStudioApi.getLogger().error("Unsuported event id " + this.event + " for network message.");
            return;
        }
        if (this.animated instanceof Entity) {
            Entity e = (Entity)this.animated;
            buf.writeShort((int)this.event);
            UUID uuid = e.func_110124_au();
            buf.writeLong(uuid.getMostSignificantBits());
            buf.writeLong(uuid.getLeastSignificantBits());
        } else if (this.animated instanceof TileEntity) {
            TileEntity te = (TileEntity)this.animated;
            buf.writeShort(this.event + 4);
            BlockPos pos = te.func_174877_v();
            buf.writeInt(pos.func_177958_n());
            buf.writeInt(pos.func_177956_o());
            buf.writeInt(pos.func_177952_p());
        } else {
            buf.writeShort(-1);
            CraftStudioApi.getLogger().error("Unsuported class " + this.animated.getClass().getSimpleName() + " for network message.");
            CraftStudioApi.getLogger().error("You are trying to animate an other class than Entity or TileEntity.");
            return;
        }
        buf.writeShort((int)this.animId);
        if (this.event != EnumIAnimatedEvent.STOP_ANIM.getId()) {
            buf.writeFloat(this.keyframeInfo);
        }
        if (this.event == EnumIAnimatedEvent.STOP_START_ANIM.getId()) {
            buf.writeShort((int)this.optAnimId);
        }
    }

    public static abstract class IAnimatedEventHandler {
        public boolean onMessage(IAnimatedEventMessage message, MessageContext ctx) {
            if (message.hasEntity) {
                Entity e = this.getEntityByUUID(ctx, message.most, message.least);
                if (!(e instanceof IAnimated)) {
                    CraftStudioApi.getLogger().error("Networking error : invalid entity.");
                    return false;
                }
                message.animated = (IAnimated)e;
            } else {
                TileEntity te = this.getTileEntityByPos(ctx, message.x, message.y, message.z);
                if (!(te instanceof IAnimated)) {
                    CraftStudioApi.getLogger().error("Networking error : invalid tile entity.");
                    return false;
                }
                message.animated = (IAnimated)te;
            }
            return true;
        }

        public abstract Entity getEntityByUUID(MessageContext var1, long var2, long var4);

        public abstract TileEntity getTileEntityByPos(MessageContext var1, int var2, int var3, int var4);
    }
}

