/*
 * Decompiled with CFR 0.152.
 */
package com.leviathanstudio.craftstudio;

import com.leviathanstudio.craftstudio.CraftStudioApi;
import com.leviathanstudio.craftstudio.client.exception.CSMalformedJsonException;
import com.leviathanstudio.craftstudio.client.exception.CSResourceNotFoundException;
import com.leviathanstudio.craftstudio.client.json.CSJsonReader;
import com.leviathanstudio.craftstudio.client.json.EnumRenderType;
import com.leviathanstudio.craftstudio.client.json.EnumResourceType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CSRegistryHelper {
    private String modid;
    private static List<LoadElement> loadModelList = new ArrayList<LoadElement>();
    private static List<LoadElement> loadAnimList = new ArrayList<LoadElement>();

    public CSRegistryHelper(String modid) {
        this.modid = modid;
    }

    public void register(EnumResourceType resourceTypeIn, EnumRenderType renderTypeIn, String resourceNameIn) {
        CSRegistryHelper.register(resourceTypeIn, renderTypeIn, resourceNameIn, this.modid);
    }

    private static void register(EnumResourceType resourceTypeIn, EnumRenderType renderTypeIn, String resourceNameIn, String modid) {
        CSRegistryHelper.capitalCheck(resourceNameIn);
        CSRegistryHelper.register(resourceTypeIn, new ResourceLocation(modid, resourceTypeIn.getPath() + renderTypeIn.getFolderName() + resourceNameIn + resourceTypeIn.getExtension()), resourceNameIn);
    }

    public static void register(EnumResourceType resourceTypeIn, ResourceLocation resourceLocationIn, String resourceNameIn) {
        switch (resourceTypeIn) {
            case MODEL: {
                if (loadModelList != null) {
                    loadModelList.add(new LoadElement(resourceLocationIn, resourceNameIn));
                    break;
                }
                CraftStudioApi.getLogger().error("Unable to load model outside of the RegistryEvent.Register<CSReadedModel> event, use forceRegister instead");
                break;
            }
            case ANIM: {
                if (loadAnimList != null) {
                    loadAnimList.add(new LoadElement(resourceLocationIn, resourceNameIn));
                    break;
                }
                CraftStudioApi.getLogger().error("Unable to load animations outside of the RegistryEvent.Register<CSReadedAnim> event, use forceRegister instead");
            }
        }
    }

    static void loadModels() {
        ProgressManager.ProgressBar progressBarModels = ProgressManager.push((String)"Registry Models", (int)loadModelList.size());
        for (LoadElement el : loadModelList) {
            progressBarModels.step("[" + el.resourceLoc.func_110624_b() + ":" + el.ressourceName + "]");
            CSRegistryHelper.registry(EnumResourceType.MODEL, el.resourceLoc, el.ressourceName);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarModels);
        CraftStudioApi.getLogger().info(String.format("CraftStudioAPI loaded %s models", loadModelList.size()));
        loadModelList = null;
    }

    static void loadAnims() {
        ProgressManager.ProgressBar progressBarAnim = ProgressManager.push((String)"Registry Animations", (int)loadAnimList.size());
        for (LoadElement el : loadAnimList) {
            progressBarAnim.step("[" + el.resourceLoc.func_110624_b() + ":" + el.ressourceName + "]");
            CSRegistryHelper.registry(EnumResourceType.ANIM, el.resourceLoc, el.ressourceName);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarAnim);
        CraftStudioApi.getLogger().info(String.format("CraftStudioAPI loaded %s animations", loadAnimList.size()));
        loadAnimList = null;
    }

    private void registry(EnumResourceType resourceTypeIn, EnumRenderType renderTypeIn, String resourceNameIn) {
        CSRegistryHelper.registry(resourceTypeIn, renderTypeIn, resourceNameIn, this.modid);
    }

    private static void registry(EnumResourceType resourceTypeIn, EnumRenderType renderTypeIn, String resourceNameIn, String modid) {
        CSRegistryHelper.capitalCheck(resourceNameIn);
        CSRegistryHelper.registry(resourceTypeIn, new ResourceLocation(modid, resourceTypeIn.getPath() + renderTypeIn.getFolderName() + resourceNameIn + resourceTypeIn.getExtension()), resourceNameIn);
    }

    private static void registry(EnumResourceType resourceTypeIn, ResourceLocation resourceLocationIn, String resourceNameIn) {
        try {
            CSJsonReader jsonReader = new CSJsonReader(resourceLocationIn);
            if (resourceLocationIn.func_110624_b() != "craftstudioapi") {
                ModContainer mod;
                ModContainer activeMod = Loader.instance().activeModContainer();
                if (activeMod != (mod = FMLCommonHandler.instance().findContainerFor((Object)resourceLocationIn.func_110624_b()))) {
                    Loader.instance().setActiveModContainer(mod);
                }
                switch (resourceTypeIn) {
                    case MODEL: {
                        GameRegistry.register((IForgeRegistryEntry)jsonReader.readModel().setRegistryName(resourceNameIn));
                        break;
                    }
                    case ANIM: {
                        GameRegistry.register((IForgeRegistryEntry)jsonReader.readAnim().setRegistryName(resourceNameIn));
                    }
                }
                Loader.instance().setActiveModContainer(activeMod);
            } else {
                CraftStudioApi.getLogger().fatal("You're not allowed to use the \"craftstudioapi\" to register CraftStudio resources.");
            }
        }
        catch (CSMalformedJsonException | CSResourceNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void capitalCheck(String str) {
        if (!str.toLowerCase().equals(str)) {
            CraftStudioApi.getLogger().warn("The resource name \"" + str + "\" contains capitals letters, which is not supported.");
            CraftStudioApi.getLogger().warn("A CSResourceNotFoundException could be raised !");
        }
    }

    private static class LoadElement {
        ResourceLocation resourceLoc;
        String ressourceName;

        LoadElement(ResourceLocation resourceLoc, String ressourceName) {
            this.resourceLoc = resourceLoc;
            this.ressourceName = ressourceName;
        }
    }
}

