/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.torocraft.torohealthmod.CommonProxy;
import net.torocraft.torohealthmod.config.ConfigurationHandler;
import net.torocraft.torohealthmod.gui.GuiEntityStatus;
import net.torocraft.torohealthmod.render.DamageParticle;

public class ClientProxy
extends CommonProxy {
    GuiEntityStatus entityStatusGUI;
    private Minecraft mc = Minecraft.func_71410_x();
    private Entity pointedEntity;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.entityStatusGUI = new GuiEntityStatus();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        MinecraftForge.EVENT_BUS.register((Object)this.entityStatusGUI);
    }

    @Override
    public void displayDamageDealt(EntityLivingBase entity) {
        int entityHealth;
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!ConfigurationHandler.showDamageParticles) {
            return;
        }
        int currentHealth = (int)Math.ceil(entity.func_110143_aJ());
        if (entity.getEntityData().func_74764_b("health") && (entityHealth = ((NBTTagInt)entity.getEntityData().func_74781_a("health")).func_150287_d()) != currentHealth) {
            this.displayParticle((Entity)entity, entityHealth - currentHealth);
        }
        entity.getEntityData().func_74782_a("health", (NBTBase)new NBTTagInt(currentHealth));
    }

    private void displayParticle(Entity entity, int damage) {
        if (damage == 0) {
            return;
        }
        World world = entity.field_70170_p;
        double motionX = world.field_73012_v.nextGaussian() * 0.02;
        double motionY = 0.5;
        double motionZ = world.field_73012_v.nextGaussian() * 0.02;
        DamageParticle damageIndicator = new DamageParticle(damage, world, entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v, motionX, motionY, motionZ);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)damageIndicator);
    }

    @Override
    public void setEntityInCrosshairs() {
        MovingObjectPosition r = this.getMouseOver(1.0f);
        if (r != null && MovingObjectPosition.MovingObjectType.ENTITY.equals((Object)r.field_72313_a) && r.field_72308_g instanceof EntityLivingBase) {
            this.entityStatusGUI.setEntity((EntityLivingBase)r.field_72308_g);
        }
    }

    public MovingObjectPosition getMouseOver(float partialTicks) {
        Entity observer = this.mc.func_175606_aa();
        MovingObjectPosition objectMouseOver = null;
        if (observer == null || this.mc.field_71441_e == null) {
            return null;
        }
        this.mc.field_147125_j = null;
        double reachDistance = 50.0;
        objectMouseOver = observer.func_174822_a(reachDistance, partialTicks);
        double d1 = reachDistance;
        Vec3 vec3 = observer.func_174824_e(partialTicks);
        boolean outOfReach = false;
        int i = 3;
        if (objectMouseOver != null) {
            d1 = objectMouseOver.field_72307_f.func_72438_d(vec3);
        }
        Vec3 vec31 = observer.func_70676_i(partialTicks);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * reachDistance, vec31.field_72448_b * reachDistance, vec31.field_72449_c * reachDistance);
        this.pointedEntity = null;
        Vec3 vec33 = null;
        float f = 1.0f;
        List list = this.mc.field_71441_e.func_175674_a(observer, observer.func_174813_aQ().func_72321_a(vec31.field_72450_a * reachDistance, vec31.field_72448_b * reachDistance, vec31.field_72449_c * reachDistance).func_72314_b((double)f, (double)f, (double)f), EntitySelectors.field_180132_d);
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            float f1 = entity1.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
            MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3, vec32);
            if (axisalignedbb.func_72318_a(vec3)) {
                if (!(d2 >= 0.0)) continue;
                this.pointedEntity = entity1;
                vec33 = movingobjectposition == null ? vec3 : movingobjectposition.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = vec3.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1 == observer.field_70154_o && !observer.canRiderInteract()) {
                if (d2 != 0.0) continue;
                this.pointedEntity = entity1;
                vec33 = movingobjectposition.field_72307_f;
                continue;
            }
            this.pointedEntity = entity1;
            vec33 = movingobjectposition.field_72307_f;
            d2 = d3;
        }
        if (this.pointedEntity != null && (d2 < d1 || this.mc.field_71476_x == null)) {
            objectMouseOver = new MovingObjectPosition(this.pointedEntity, vec33);
            if (this.pointedEntity instanceof EntityLivingBase || this.pointedEntity instanceof EntityItemFrame) {
                this.mc.field_147125_j = this.pointedEntity;
            }
        }
        return objectMouseOver;
    }

    private boolean isSolidBlock(BlockPos pos, BlockPos prevPos) {
        return prevPos.compareTo((Vec3i)pos) == 0;
    }
}

