/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealthmod.gui;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.torohealthmod.config.ConfigurationHandler;

public class GuiEntityStatus
extends Gui {
    private Minecraft mc;
    private EntityLivingBase entity;
    private int age = 0;
    private boolean showHealthBar = false;
    private ScaledResolution viewport;
    private final int PADDING_FROM_EDGE = 2;
    String displayPosition;
    int screenX = 2;
    int screenY = 2;
    int displayHeight;
    int displayWidth;
    private int entityRenderWidth;
    private final int entityRenderHeightUnit = 20;
    private final int entityRenderX = 20;
    private Entity leashedToEntity;
    private int entityHealth = 0;
    private int lastEntityHealth = 0;
    private long lastSystemTime = 0L;
    private int updateCounter;
    private long healthUpdateCounter = 0L;
    private Random rand = new Random();

    public GuiEntityStatus() {
        this(Minecraft.func_71410_x());
    }

    public GuiEntityStatus(Minecraft mc) {
        this.mc = mc;
    }

    public void setEntity(EntityLivingBase entityToTrack) {
        this.showHealthBar();
        this.age = 0;
        if (this.entity != null && this.entity.func_110124_au().equals(entityToTrack.func_110124_au())) {
            return;
        }
        this.entity = entityToTrack;
    }

    @SubscribeEvent
    public void drawHealthBar(RenderGameOverlayEvent event) {
        if (!this.showHealthBar) {
            return;
        }
        String entityStatusDisplay = ConfigurationHandler.entityStatusDisplay;
        ++this.age;
        if (this.age > ConfigurationHandler.hideDelay || entityStatusDisplay.equals("OFF")) {
            this.hideHealthBar();
        }
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        boolean showEntityModel = ConfigurationHandler.showEntityModel;
        this.entityRenderWidth = showEntityModel ? 40 : 0;
        this.viewport = new ScaledResolution(this.mc);
        this.displayPosition = ConfigurationHandler.statusDisplayPosition;
        if (this.isUnsupportedDisplayType(entityStatusDisplay)) {
            entityStatusDisplay = "HEARTS";
        }
        if (entityStatusDisplay.equals("NUMERIC")) {
            this.drawNumericDisplayStyle();
        } else if (entityStatusDisplay.equals("HEARTS")) {
            this.drawHeartsDisplay();
        }
        if (showEntityModel) {
            try {
                this.drawEntityOnScreen();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void drawEntityOnScreen() {
        int sw = this.viewport.func_78326_a();
        int sh = this.viewport.func_78328_b();
        int entityRenderHeight = 20;
        double h = (float)entityRenderHeight / this.entity.field_70131_O;
        if (this.displayPosition.contains("TOP")) {
            this.screenY = entityRenderHeight + 5;
        }
        if (this.displayPosition.contains("BOTTOM")) {
            this.screenY = sh - this.displayHeight + entityRenderHeight;
        }
        if (this.displayPosition.contains("LEFT")) {
            this.screenX = 20;
        }
        if (this.displayPosition.contains("RIGHT")) {
            this.screenX = sw - this.entityRenderWidth + 10;
        }
        if (this.displayPosition.contains("CENTER")) {
            this.screenX = (sw - this.entityRenderWidth - this.displayWidth) / 2;
        }
        if (this.displayPosition.equals("CUSTOM")) {
            this.screenX = ConfigurationHandler.statusDisplayX + this.entityRenderWidth / 2;
            this.screenY = ConfigurationHandler.statusDisplayY + entityRenderHeight + 10;
        }
        int scale = MathHelper.func_76143_f((double)h);
        if (this.entity instanceof EntityLiving && ((EntityLiving)this.entity).func_110167_bD()) {
            this.leashedToEntity = ((EntityLiving)this.entity).func_110166_bE();
            ((EntityLiving)this.entity).func_110162_b(null, false);
        }
        float prevYawOffset = this.entity.field_70761_aq;
        float prevYaw = this.entity.field_70177_z;
        float prevPitch = this.entity.field_70125_A;
        float prevYawHead = this.entity.field_70759_as;
        float prevPrevYahHead = this.entity.field_70758_at;
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.screenX, (float)this.screenY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.entity.field_70761_aq = 0.0f;
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70759_as = 0.0f;
        this.entity.field_70758_at = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_147939_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        this.entity.field_70761_aq = prevYawOffset;
        this.entity.field_70177_z = prevYaw;
        this.entity.field_70125_A = prevPitch;
        this.entity.field_70759_as = prevYawHead;
        this.entity.field_70758_at = prevPrevYahHead;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        if (this.entity instanceof EntityLiving && this.leashedToEntity != null) {
            ((EntityLiving)this.entity).func_110162_b(this.leashedToEntity, false);
            this.leashedToEntity = null;
        }
    }

    private boolean isUnsupportedDisplayType(String entityStatusDisplay) {
        return !entityStatusDisplay.equals("HEARTS") && !entityStatusDisplay.equals("NUMERIC");
    }

    private void drawNumericDisplayStyle() {
        ResourceLocation spriteLoc = new ResourceLocation("torohealthmod", "textures/gui/entityStatus.png");
        this.mc.field_71446_o.func_110577_a(spriteLoc);
        int bgX = 0;
        int bgY = 0;
        int healthBarX = 2;
        int healthBarY = 16;
        int nameX = 50;
        int nameY = 4;
        int healthX = 50;
        int healthY = 20;
        this.displayWidth = 100;
        this.displayHeight = 34;
        this.adjustForDisplayPositionSetting();
        Gui.func_146110_a((int)(this.screenX + bgX), (int)(this.screenY + bgY), (float)0.0f, (float)0.0f, (int)this.displayWidth, (int)this.displayHeight, (float)200.0f, (float)200.0f);
        Gui.func_146110_a((int)(this.screenX + healthBarX), (int)(this.screenY + healthBarY), (float)0.0f, (float)150.0f, (int)96, (int)16, (float)200.0f, (float)200.0f);
        int currentHealthWidth = (int)Math.ceil(96.0f * (this.entity.func_110143_aJ() / this.entity.func_110138_aP()));
        Gui.func_146110_a((int)(this.screenX + healthBarX), (int)(this.screenY + healthBarY), (float)0.0f, (float)100.0f, (int)currentHealthWidth, (int)16, (float)200.0f, (float)200.0f);
        String name = this.getDisplayName();
        this.func_73732_a(this.mc.field_71466_p, name, this.screenX + nameX, this.screenY + nameY, 0xFFFFFF);
        this.func_73732_a(this.mc.field_71466_p, (int)Math.ceil(this.entity.func_110143_aJ()) + "/" + (int)this.entity.func_110138_aP(), this.screenX + healthX, this.screenY + healthY, 0xFFFFFF);
    }

    private void drawHeartsDisplay() {
        this.screenX = 2;
        this.screenY = 2;
        this.displayHeight = 74;
        this.displayWidth = 84;
        this.adjustForDisplayPositionSetting();
        this.drawName();
        this.drawHearts();
        this.drawArmor();
    }

    private void drawName() {
        String name = this.getDisplayName();
        this.func_73731_b(this.mc.field_71466_p, name, this.screenX, this.screenY, 0xFFFFFF);
        this.screenY += 10;
    }

    private int drawHearts() {
        int absorptionAmount;
        int currentHealth;
        this.mc.field_71446_o.func_110577_a(field_110324_m);
        this.entityHealth = currentHealth = MathHelper.func_76123_f((float)this.entity.func_110143_aJ());
        int remainingAbsorption = absorptionAmount = MathHelper.func_76123_f((float)this.entity.func_110139_bj());
        float maxHealth = this.entity.func_110138_aP();
        int numRowsOfHearts = MathHelper.func_76123_f((float)((maxHealth + (float)absorptionAmount) / 2.0f / 10.0f));
        int j2 = Math.max(10 - (numRowsOfHearts - 2), 3);
        for (int currentHeartBeingDrawn = MathHelper.func_76123_f((float)((maxHealth + (float)absorptionAmount) / 2.0f)) - 1; currentHeartBeingDrawn >= 0; --currentHeartBeingDrawn) {
            int texturePosX = 16;
            int flashingHeartOffset = 0;
            int rowsOfHearts = MathHelper.func_76123_f((float)((float)(currentHeartBeingDrawn + 1) / 10.0f)) - 1;
            int heartToDrawX = this.screenX + currentHeartBeingDrawn % 10 * 8;
            int heartToDrawY = this.screenY + rowsOfHearts * j2;
            int hardcoreModeOffset = 0;
            if (this.entity.field_70170_p.func_72912_H().func_76093_s()) {
                hardcoreModeOffset = 5;
            }
            this.func_73729_b(heartToDrawX, heartToDrawY, 16 + flashingHeartOffset * 9, 9 * hardcoreModeOffset, 9, 9);
            if (remainingAbsorption > 0) {
                if (remainingAbsorption == absorptionAmount && absorptionAmount % 2 == 1) {
                    this.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 153, 9 * hardcoreModeOffset, 9, 9);
                    --remainingAbsorption;
                    continue;
                }
                this.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 144, 9 * hardcoreModeOffset, 9, 9);
                remainingAbsorption -= 2;
                continue;
            }
            if (currentHeartBeingDrawn * 2 + 1 < currentHealth) {
                this.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 36, 9 * hardcoreModeOffset, 9, 9);
            }
            if (currentHeartBeingDrawn * 2 + 1 != currentHealth) continue;
            this.func_73729_b(heartToDrawX, heartToDrawY, texturePosX + 45, 9 * hardcoreModeOffset, 9, 9);
        }
        this.screenY += (numRowsOfHearts - 1) * j2 + 10;
        return remainingAbsorption;
    }

    private void drawArmor() {
        this.mc.field_71446_o.func_110577_a(field_110324_m);
        int armor = this.entity.func_70658_aO();
        for (int i = 0; i < 10; ++i) {
            if (armor <= 0) continue;
            int armorIconX = this.screenX + i * 8;
            if (i * 2 + 1 < armor) {
                this.func_73729_b(armorIconX, this.screenY, 34, 9, 9, 9);
            }
            if (i * 2 + 1 == armor) {
                this.func_73729_b(armorIconX, this.screenY, 25, 9, 9, 9);
            }
            if (i * 2 + 1 <= armor) continue;
            this.func_73729_b(armorIconX, this.screenY, 16, 9, 9, 9);
        }
        this.screenY += 10;
    }

    private void adjustForDisplayPositionSetting() {
        int sh = this.viewport.func_78328_b();
        int sw = this.viewport.func_78326_a();
        if (this.displayPosition.equals("CUSTOM")) {
            this.screenX = ConfigurationHandler.statusDisplayX + this.entityRenderWidth;
            this.screenY = ConfigurationHandler.statusDisplayY;
            return;
        }
        if (this.displayPosition.contains("TOP")) {
            this.screenY = 2;
        }
        if (this.displayPosition.contains("BOTTOM")) {
            this.screenY = sh - this.displayHeight - 2;
        }
        if (this.displayPosition.contains("LEFT")) {
            this.screenX = this.entityRenderWidth + 2;
        }
        if (this.displayPosition.contains("RIGHT")) {
            this.screenX = sw - this.displayWidth - 2 - this.entityRenderWidth - 10;
        }
        if (this.displayPosition.contains("CENTER")) {
            this.screenX = (sw - this.displayWidth) / 2;
        }
    }

    private boolean isHealthUpdateOver() {
        return Minecraft.func_71386_F() - this.lastSystemTime > 1000L;
    }

    private boolean isBeingHealed(int currentHealth) {
        return currentHealth > this.entityHealth && this.entity.field_70172_ad > 0;
    }

    private boolean isBeingDamaged(int currentHealth) {
        return currentHealth < this.entityHealth && this.entity.field_70172_ad > 0;
    }

    private String getDisplayName() {
        String name = this.entity.func_145748_c_().func_150254_d();
        return name;
    }

    private void showHealthBar() {
        this.showHealthBar = true;
    }

    private void hideHealthBar() {
        this.showHealthBar = false;
    }
}

