/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.client.mainmenu.utilities;

import com.mojang.authlib.GameProfile;
import com.ubalube.scifiaddon.client.mainmenu.utilities.FakePlayerRendering;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiRenderHelper {
    public static float swing = 0.0f;
    public static final FakePlayerRendering PLAYER_RENDERER = new FakePlayerRendering(Minecraft.func_71410_x().func_110432_I().func_148256_e());

    public static void renderColor(int par1, double alpha) {
        Color color = Color.decode("" + par1);
        double red = (double)color.getRed() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
    }

    public static void renderText(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, posX, posY, color);
    }

    public static void renderTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a(text, (float)posX, (float)posY, color);
    }

    public static void renderCenteredText(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiRenderHelper.renderText(text, posX - mc.field_71466_p.func_78256_a(text) / 2, posY, color);
    }

    public static void renderCenteredTextWithShadow(String text, int posX, int posY, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiRenderHelper.renderTextWithShadow(text, posX - mc.field_71466_p.func_78256_a(text) / 2, posY, color);
    }

    public static void renderTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiRenderHelper.renderText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaled(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiRenderHelper.renderCenteredText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithShadow(String text, int posX, int posY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiRenderHelper.renderCenteredTextWithShadow(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        GuiRenderHelper.renderText(text, x - 1, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x + 1, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x - 1, y, outlineColor);
        GuiRenderHelper.renderText(text, x + 1, y, outlineColor);
        GuiRenderHelper.renderText(text, x - 1, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x + 1, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x, y, color);
    }

    public static void renderTextScaledWithOutline(String text, int x, int y, int color, int outlineColor, double givenScale) {
        GuiRenderHelper.renderTextScaled(text, x - 1, y + 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x, y + 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x + 1, y + 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x - 1, y, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x + 1, y, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x - 1, y - 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x, y - 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x + 1, y - 1, outlineColor, givenScale);
        GuiRenderHelper.renderTextScaled(text, x, y, color, givenScale);
    }

    public static void renderCenteredTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fr = mc.field_71466_p;
        GuiRenderHelper.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y + 1, outlineColor);
        GuiRenderHelper.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y, outlineColor);
        GuiRenderHelper.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y, outlineColor);
        GuiRenderHelper.renderText(text, x - 1 - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x + 1 - fr.func_78256_a(text) / 2, y - 1, outlineColor);
        GuiRenderHelper.renderText(text, x - fr.func_78256_a(text) / 2, y, color);
    }

    public static void renderRect(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor) {
        GL11.glPushMatrix();
        givenHeight += givenPosY;
        if (givenPosX < (givenWidth += givenPosX)) {
            int i = givenPosX;
            givenPosX = givenWidth;
            givenWidth = i;
        }
        if (givenPosY < givenHeight) {
            int j = givenPosY;
            givenPosY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f4 = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f4, (float)f5, (float)f6, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenPosY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenPosY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GL11.glPopMatrix();
    }

    public static void renderRect(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor, float givenAlpha) {
        givenHeight += givenPosY;
        if (givenPosX < (givenWidth += givenPosX)) {
            int i = givenPosX;
            givenPosX = givenWidth;
            givenWidth = i;
        }
        if (givenPosY < givenHeight) {
            int j = givenPosY;
            givenPosY = givenHeight;
            givenHeight = j;
        }
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f2, (float)f3, (float)givenAlpha);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenPosY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenPosY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithOutline(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int givenColor, int givenOutlineColor, int outlineThickness) {
        GL11.glPushMatrix();
        GuiRenderHelper.renderRect(givenPosX - outlineThickness, givenPosY - outlineThickness, givenWidth + outlineThickness * 2, givenHeight + outlineThickness * 2, givenOutlineColor);
        GuiRenderHelper.renderRect(givenPosX, givenPosY, givenWidth, givenHeight, givenColor);
        GL11.glPopMatrix();
    }

    public static void renderRectWithFade(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, float givenFade) {
        givenHeight += givenY;
        if (givenX < (givenWidth += givenX)) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f4 = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f4, (float)f5, (float)f6, (float)givenFade);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithGradient(int givenPosX, int givenPosY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel) {
        GL11.glPushMatrix();
        givenWidth += givenPosX;
        givenHeight += givenPosY;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f3 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f4 = (float)(startColor & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f7 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f8 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenPosY, givenZLevel).func_181666_a(f2, f3, f4, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenPosY, givenZLevel).func_181666_a(f2, f3, f4, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenPosX, (double)givenHeight, givenZLevel).func_181666_a(f6, f7, f8, f5).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f6, f7, f8, f5).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
    }

    public static void renderPositionedImageNoDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GuiRenderHelper.renderPositionedImage(par1, par2, par3, par4, par5, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void renderPositionedImage(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiRenderHelper.renderImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextScaled(String givenText, double par2, double par3, double par4, float par5, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiRenderHelper.renderCenteredTextScaled(givenText, 0, 0, givenColor, par5);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderImageCenteredScaled(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiRenderHelper.renderImageCentered(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static void renderImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        GuiRenderHelper.renderImage(givenX - givenWidth / 2.0, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static void renderImageTransparent(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GuiRenderHelper.renderColor(0xFFFFFF, alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderImageCenteredTransparent(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double alpha) {
        GlStateManager.func_179094_E();
        GuiRenderHelper.renderImageTransparent(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight, alpha);
        GlStateManager.func_179121_F();
    }

    public static void renderImage(double x, double y, ResourceLocation image, double width, double height) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderOtherPlayer(GameProfile profile, int x, int y, float givenScale, float givenRotation, ItemStack helm, ItemStack chest, ItemStack legs, ItemStack boots, ItemStack held) {
        GL11.glPushMatrix();
        PLAYER_RENDERER.renderOtherPlayerModel(profile, x, y, givenScale, givenRotation, helm, chest, legs, boots, held);
        GL11.glPopMatrix();
    }

    public static void renderPlayer(int x, int y, float givenScale, float givenRotation, ItemStack helm, ItemStack chest, ItemStack legs, ItemStack boots, ItemStack held) {
        GL11.glPushMatrix();
        PLAYER_RENDERER.renderPlayerModel(x, y, givenScale, givenRotation, helm, chest, legs, boots, held);
        GL11.glPopMatrix();
    }
}

