/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.commands;

import com.ubalube.scifiaddon.main;
import com.ubalube.scifiaddon.util.WorldData;
import com.ubalube.scifiaddon.util.packets.MessageSaveData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandTeam
extends CommandBase {
    public String func_71517_b() {
        return "squad";
    }

    public String func_71518_a(ICommandSender sender) {
        return "squad <create,leave,help,invite,join,kick> <args>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            EntityPlayer theSender = (EntityPlayer)sender;
            WorldData data = WorldData.get(theSender.func_130014_f_());
            switch (args[0]) {
                case "create": {
                    String name = args[1];
                    if (WorldData.teams.containsKey(name)) {
                        theSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "The squad " + name + " already exists!"));
                        return;
                    }
                    if (name.contains("!") || name.contains("?") || name.contains(">") || name.contains("<")) {
                        theSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can not use the following symbols in a squad name: !, ?, >, <"));
                        return;
                    }
                    if (WorldData.team.containsKey(theSender.func_110124_au())) {
                        theSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You are already in a squad: " + TextFormatting.GREEN + WorldData.team.get(theSender.func_110124_au())));
                        theSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You must leave that squad to make your own!"));
                        return;
                    }
                    data.addNewTeam(name, theSender);
                    theSender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have created a squad named: " + name));
                    break;
                }
                case "kick": {
                    try {
                        String playerName = args[1];
                        UUID uid = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(playerName).getId();
                        if (!WorldData.team.containsKey(uid)) break;
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + playerName + " has been kicked from your squad!"));
                        data.removePlayer((EntityPlayer)sender, uid);
                    }
                    catch (Exception ex) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "That player is offline or does not exist!"));
                    }
                    break;
                }
                case "invite": {
                    try {
                        String playerName = args[1];
                        EntityPlayerMP newp = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
                        EntityPlayer oldp = (EntityPlayer)sender;
                        UUID uuid = newp.func_110124_au();
                        String theteam = WorldData.team.get(oldp.func_110124_au());
                        if (WorldData.teams.get(theteam).contains(uuid)) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "That player is already in your squad!"));
                            return;
                        }
                        if (newp.func_110124_au().equals(oldp.func_110124_au())) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't invite yourself to your own squad!"));
                            return;
                        }
                        newp.getEntityData().func_74778_a("invitedby", oldp.func_110124_au().toString());
                        oldp.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have invited " + newp.getDisplayNameString() + " to your squad"));
                        newp.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have been invited by " + oldp.getDisplayNameString() + " to join their squad. Type /squad join to join them!"));
                    }
                    catch (Exception ex) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Must enter an online player's username to invite"));
                    }
                    break;
                }
                case "leave": {
                    try {
                        EntityPlayer p = (EntityPlayer)sender;
                        String toLeave = WorldData.team.get(p.func_110124_au());
                        data.removePlayer(p, p.func_110124_au());
                        p.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully left the squad!"));
                        for (UUID pla : WorldData.teams.get(toLeave)) {
                            p.func_184102_h().func_184103_al().func_177451_a(pla).func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + p.getDisplayNameString() + " has left your squad!"));
                        }
                        if (!WorldData.teams.get(toLeave).isEmpty()) break;
                        data.removeTeam(toLeave);
                    }
                    catch (Exception ex) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You're not in a squad"));
                    }
                    break;
                }
                case "join": {
                    EntityPlayer invitee = (EntityPlayer)sender;
                    EntityPlayerMP inviter = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(invitee.getEntityData().func_74779_i("invitedby")));
                    UUID uid = invitee.func_110124_au();
                    if (inviter == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have not been invited to a squad!"));
                        break;
                    }
                    if (WorldData.team.containsKey(uid)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You were removed from your old squad!"));
                        data.removePlayer(invitee, uid);
                    }
                    if (WorldData.team.containsKey(inviter.func_110124_au()) && inviter != null) {
                        String string = WorldData.team.get(inviter.func_110124_au());
                    }
                    data.addPlayerToTeam((EntityPlayer)inviter, uid);
                    main.NETWORK.sendTo((IMessage)new MessageSaveData(WorldData.teams), (EntityPlayerMP)invitee);
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Joined " + inviter.getDisplayNameString() + "'s squad!"));
                    inviter.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + invitee.getDisplayNameString() + " has joined your squad!"));
                    break;
                }
                case "help": {
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Diamond Caliber squad"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad create <name> - creates a squad"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad invite <playername> - invites a player to your squad"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad kick <playername> - kicks a player from your squad"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad join - joins the current squad invite"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad leave - leaves the current squad"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "/squad help - shows this menu"));
                }
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> tabCompletions = new ArrayList<String>();
        if (args.length == 0) {
            tabCompletions.clear();
            tabCompletions.add("create");
            tabCompletions.add("invite");
            tabCompletions.add("kick");
            tabCompletions.add("join");
            tabCompletions.add("leave");
            tabCompletions.add("help");
        } else {
            tabCompletions.clear();
            if (args.length > 0) {
                for (String p : server.func_71213_z()) {
                    tabCompletions.add(p);
                }
            }
        }
        return tabCompletions;
    }
}

