/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.data;

import com.ubalube.scifiaddon.commands.util.Loadout;
import com.ubalube.scifiaddon.commands.util.LoadoutSlots;
import com.ubalube.scifiaddon.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class LoadoutData
extends WorldSavedData {
    private static final String DATA_NAME = "caliber_loadoutData";
    public static List<Loadout> loadouts = new ArrayList<Loadout>();
    private boolean loaded = false;

    public LoadoutData() {
        super(DATA_NAME);
    }

    public LoadoutData(String name) {
        super(name);
    }

    public void load(World worldIn) {
        if (!this.loaded) {
            this.get(worldIn);
            for (Loadout loadout : loadouts) {
                System.out.println("Loaded Loadout");
            }
            this.loaded = true;
        }
    }

    public LoadoutData get(World world) {
        MapStorage storage = world.func_175693_T();
        LoadoutData data = (LoadoutData)storage.func_75742_a(LoadoutData.class, DATA_NAME);
        if (data == null) {
            data = new LoadoutData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }

    public void setLoadout(LoadoutSlots slots, Loadout loadout) {
        int slotToModify = 0;
        if (slots.equals((Object)LoadoutSlots.LOADOUT1)) {
            slotToModify = 1;
        }
        if (slots.equals((Object)LoadoutSlots.LOADOUT2)) {
            slotToModify = 2;
        }
        if (slots.equals((Object)LoadoutSlots.LOADOUT3)) {
            slotToModify = 3;
        }
        if (slots.equals((Object)LoadoutSlots.LOADOUT4)) {
            slotToModify = 4;
        }
        LoadoutData.loadouts.get((int)slotToModify).items = loadout.items;
        LoadoutData.loadouts.get((int)slotToModify).Primary = loadout.Primary;
        LoadoutData.loadouts.get((int)slotToModify).Secondary = loadout.Secondary;
    }

    public List<Loadout> getLoadouts() {
        if (loadouts.size() < 3) {
            for (int i = loadouts.size(); i < 3; ++i) {
                Loadout loadout = new Loadout();
                loadout.Primary = new ItemStack(ModItems.AK12);
                loadout.Secondary = new ItemStack(ModItems.GLOCK_SCOPED);
                loadouts.add(loadout);
            }
        }
        return loadouts;
    }

    public Loadout getLoadout(String name) {
        for (Loadout l : loadouts) {
            if (l.loadoutName != name) continue;
            return l;
        }
        return null;
    }

    public String getPrefix(Loadout l) {
        String prefix = "";
        for (Loadout loadout : loadouts) {
            if (loadout != l) continue;
            prefix = this.getLoadoutSlotByName(l.loadoutName).toString();
        }
        return prefix;
    }

    public LoadoutSlots getLoadoutSlotByName(String s) {
        int i = 0;
        LoadoutSlots slot = null;
        for (Loadout l : loadouts) {
            if (l.loadoutName == s) {
                if (i == 1) {
                    slot = LoadoutSlots.LOADOUT1;
                }
                if (i == 2) {
                    slot = LoadoutSlots.LOADOUT2;
                }
                if (i == 3) {
                    slot = LoadoutSlots.LOADOUT3;
                }
                if (i != 4) break;
                slot = LoadoutSlots.LOADOUT4;
                break;
            }
            ++i;
        }
        return slot;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        ArrayList<Loadout> newLoadouts = new ArrayList<Loadout>();
        for (LoadoutSlots l : LoadoutSlots.values()) {
            if (!nbt.func_74764_b(l.toString())) continue;
            newLoadouts.add(this.getLoadout(nbt.func_74779_i(l.toString())));
        }
        loadouts = newLoadouts;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        for (Loadout loadout : loadouts) {
            compound.func_74778_a(this.getPrefix(loadout), loadout.loadoutName);
        }
        return compound;
    }
}

