/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.recipes.SkinnerRecipes;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.ubalube.scifiaddon.init.ModItems;
import com.ubalube.scifiaddon.items.GunAttachments;
import com.ubalube.scifiaddon.items.GunBase;
import com.ubalube.scifiaddon.items.ItemModification;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class WorkshopRecipes {
    private static final WorkshopRecipes INSTANCE = new WorkshopRecipes();
    private final Table<ItemStack, ItemStack, ItemStack> smeltingList = HashBasedTable.create();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static WorkshopRecipes getInstance() {
        return INSTANCE;
    }

    private WorkshopRecipes() {
        this.addHarvestorRecipe(new ItemStack(Items.field_151036_c), new ItemStack(Items.field_151107_aW), new ItemStack(ModItems.STATTRACK), 5.0f);
        this.addHarvestorRecipe(new ItemStack(Items.field_151036_c), new ItemStack(Blocks.field_150325_L), new ItemStack(ModItems.LOWRECOIL), 5.0f);
        this.addHarvestorRecipe(new ItemStack(Items.field_151056_x), new ItemStack(Items.field_151040_l), new ItemStack(ModItems.INCREASEDAMAGE), 5.0f);
        this.addHarvestorRecipe(new ItemStack(Items.field_151069_bo), new ItemStack(Items.field_151072_bj), new ItemStack(ModItems.BULLETEFFECT), 5.0f);
        for (Item i : ModItems.ITEMS) {
            if (!(i instanceof GunBase)) continue;
            this.addModificationRecipe(new ItemStack(i), new ItemStack(ModItems.INCREASEDAMAGE), 2.0f);
            this.addModificationRecipe(new ItemStack(i), new ItemStack(ModItems.LOWRECOIL), 2.0f);
            this.addModificationRecipe(new ItemStack(i), new ItemStack(ModItems.STATTRACK), 2.0f);
            this.addModificationRecipe(new ItemStack(i), new ItemStack(ModItems.BULLETEFFECT), 2.0f);
        }
    }

    public void addHarvestorRecipe(ItemStack input1, ItemStack input2, ItemStack result, float experience) {
        if (this.getHarvestorResult(input1, input2) != ItemStack.field_190927_a) {
            return;
        }
        this.smeltingList.put((Object)input1, (Object)input2, (Object)result);
        this.experienceList.put(result, Float.valueOf(experience));
    }

    public void addModificationRecipe(ItemStack weapon, ItemStack modification, float experience) {
        ItemStack result = weapon.func_77946_l();
        ItemModification mod = (ItemModification)modification.func_77973_b();
        GunBase gun = (GunBase)result.func_77973_b();
        if (this.getHarvestorResult(weapon, modification) != ItemStack.field_190927_a) {
            return;
        }
        this.smeltingList.put((Object)weapon, (Object)modification, (Object)result);
        this.experienceList.put(result, Float.valueOf(experience));
        if (mod.getModification() == GunAttachments.POTIONEFFECT) {
            if (mod.getPotionEffect() != null && modification.func_77973_b() instanceof ItemModification) {
                if (mod.getModification() == GunAttachments.POTIONEFFECT) {
                    gun.addPotionEffect(mod.getPotionEffect().func_188419_a(), result);
                }
                gun.addModification(mod.getModification(), result);
            }
        } else if (modification.func_77973_b() instanceof ItemModification) {
            if (mod.getModification() == GunAttachments.STATTRACK) {
                gun.addStatTrack(result);
            }
            gun.addModification(mod.getModification(), result);
        }
    }

    public ItemStack getHarvestorResult(ItemStack input1, ItemStack input2) {
        for (Map.Entry entry : this.smeltingList.columnMap().entrySet()) {
            if (!this.compareItemStacks(input1, (ItemStack)entry.getKey())) continue;
            for (Map.Entry ent : ((Map)entry.getValue()).entrySet()) {
                if (!this.compareItemStacks(input2, (ItemStack)ent.getKey())) continue;
                return (ItemStack)ent.getValue();
            }
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Table<ItemStack, ItemStack, ItemStack> getDualSmeltingList() {
        return this.smeltingList;
    }

    public float getHarvestorExperience(ItemStack stack) {
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

