/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.util;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.ubalube.scifiaddon.items.GunBase;
import com.ubalube.scifiaddon.util.WorldData;
import com.ubalube.scifiaddon.util.handlers.ConfigHandler;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class DiamondCaliberHUD {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && player.func_184614_ca().func_77973_b() instanceof GunBase && ConfigHandler.ClientSide.dcCrosshair) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution sr = new ScaledResolution(mc);
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77973_b() instanceof GunBase) {
                event.setCanceled(true);
                GunBase cfr_ignored_0 = (GunBase)stack.func_77973_b();
                NBTTagCompound nbt2 = GunBase.checkNBTTags(stack);
                if (!nbt2.func_74767_n("ADS")) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(Gui.field_110324_m);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_179141_d();
                    float gunDamage = (int)((GunBase)stack.func_77973_b()).getGunDamage();
                    int x = sr.func_78326_a() / 2;
                    int y = sr.func_78328_b() / 2;
                    int spacing = MathHelper.func_76125_a((int)Math.round(100.0f * gunDamage), (int)1, (int)10);
                    Gui gui = new Gui();
                    gui.func_73729_b(x - (4 + spacing), y, 3, 7, 4, 1);
                    gui.func_73729_b(x + (1 + spacing), y, 8, 7, 4, 1);
                    gui.func_73729_b(x, y, 7, 7, 1, 1);
                    gui.func_73729_b(x, y - (4 + spacing), 7, 3, 1, 4);
                    gui.func_73729_b(x, y + (1 + spacing), 7, 8, 1, 4);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public void onRenderGameOverlyEvent(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP playerIn = mc.field_71439_g;
        ScaledResolution sr = new ScaledResolution(mc);
        ItemStack item = playerIn.func_184614_ca();
        if (!item.func_190926_b() && item.func_77973_b() instanceof GunBase && ConfigHandler.ClientSide.weaponHud) {
            GunBase gb = (GunBase)item.func_77973_b();
            this.drawAmmo(mc, sr, gb, item, (EntityPlayer)playerIn, 0);
        }
        if (WorldData.team.containsKey(playerIn.func_110124_au())) {
            this.drawTeamList(mc, sr, item, (EntityPlayer)playerIn, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=false)
    public void doStatTrack(LivingDeathEvent e) {
        DamageSource source = e.getSource();
        if (source.func_76346_g() instanceof EntityPlayer) {
            GunBase gb;
            EntityPlayer attacker = (EntityPlayer)source.func_76346_g();
            Entity victim = e.getEntity();
            if (attacker.func_184614_ca().func_77973_b() instanceof GunBase && (gb = (GunBase)attacker.func_184614_ca().func_77973_b()).hasStatTrack(attacker.func_184614_ca()).booleanValue()) {
                gb.addStatTrackKill(1, attacker.func_184614_ca());
            }
        }
    }

    private void drawAmmo(Minecraft mc, ScaledResolution sr, GunBase gb, ItemStack item, EntityPlayer playerIn, int i) {
        ItemStack ammo = new ItemStack(gb.ammo);
        int currentAmmo = item.func_77958_k() - item.func_77952_i();
        int maxAmmo = item.func_77958_k();
        int ammoPercent = (int)((float)currentAmmo * 100.0f) / maxAmmo;
        String ammoText = "";
        String GunName = ChatFormatting.GREEN + item.func_82833_r();
        GunBase cfr_ignored_0 = (GunBase)item.func_77973_b();
        NBTTagCompound nbt2 = GunBase.checkNBTTags(item);
        if (nbt2.func_74767_n("reload")) {
            ammoText = ChatFormatting.YELLOW + "-RELOADING-";
        } else if (ammoPercent > 50) {
            ammoText = ChatFormatting.GREEN + "" + currentAmmo + ChatFormatting.WHITE + "/" + ChatFormatting.GREEN + maxAmmo;
        } else if (ammoPercent <= 50 && ammoPercent > 25) {
            ammoText = ChatFormatting.YELLOW + "" + currentAmmo + ChatFormatting.WHITE + "/" + ChatFormatting.GREEN + maxAmmo;
        } else if (ammoPercent <= 25 && ammoPercent > 0) {
            ammoText = ChatFormatting.RED + "" + currentAmmo + ChatFormatting.WHITE + "/" + ChatFormatting.GREEN + maxAmmo;
        } else if (ammoPercent <= 0) {
            ammoText = ChatFormatting.DARK_RED + "" + ChatFormatting.BOLD + "OUT OF AMMO";
        }
        if (gb.hasStatTrack(item).booleanValue()) {
            String StatTrack = ChatFormatting.YELLOW + "x" + gb.getStatTrackCount(item);
            mc.field_71466_p.func_78276_b(StatTrack, sr.func_78326_a() - 40 - ammoText.length() * 6, sr.func_78328_b() - mc.field_71466_p.field_78288_b - 2 + i, -1);
        }
        mc.field_71466_p.func_78276_b(GunName, sr.func_78326_a() - 7 - ammoText.length() * 6, sr.func_78328_b() - mc.field_71466_p.field_78288_b - 12 + i, -1);
        mc.field_71466_p.func_78276_b(ammoText, sr.func_78326_a() - 7 - ammoText.length() * 6, sr.func_78328_b() - mc.field_71466_p.field_78288_b - 2 + i, -1);
    }

    private void drawTeamList(Minecraft mc, ScaledResolution sr, ItemStack item, EntityPlayer playerIn, int i) {
        String teamName = WorldData.team.get(playerIn.func_110124_au());
        int lastYPos = 500;
        for (UUID uuid : WorldData.teams.get(teamName)) {
            EntityPlayerMP p = playerIn.func_184102_h().func_184103_al().func_177451_a(uuid);
            if (p == playerIn) {
                this.drawText(mc, sr, i, lastYPos, TextFormatting.YELLOW + p.getDisplayNameString());
            } else {
                this.drawText(mc, sr, i, lastYPos, p.getDisplayNameString());
            }
            lastYPos -= 25;
        }
    }

    private void drawText(Minecraft mc, ScaledResolution sr, int i, int lastYPos, String text) {
        mc.field_71466_p.func_78276_b(text, sr.func_78326_a() - 500 - text.length() * 6, sr.func_78328_b() - mc.field_71466_p.field_78288_b - lastYPos + i, -1);
    }
}

