/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class WorldData
extends WorldSavedData {
    public static Map<UUID, String> team = new HashMap<UUID, String>();
    public static Map<String, List<UUID>> teams = new HashMap<String, List<UUID>>();
    public static Map<String, UUID> teamOwner = new HashMap<String, UUID>();

    public WorldData() {
        super("caliber");
    }

    public WorldData(String name) {
        super(name);
        this.func_76185_a();
    }

    public void setTeamOwner(EntityPlayer owner, String name) {
        teamOwner.put(name, owner.func_110124_au());
    }

    public UUID getTeamOwner(String teamName) {
        return teamOwner.get(teamName);
    }

    public void addNewTeam(String name, EntityPlayer owner) {
        ArrayList<UUID> list = new ArrayList<UUID>();
        list.add(owner.func_110124_au());
        teams.put(name, list);
        team.put(owner.func_110124_au(), name);
        teamOwner.put(name, owner.func_110124_au());
        this.func_76185_a();
    }

    public void addPlayerToTeam(EntityPlayer owner, UUID uuid) {
        String name = team.get(owner.func_110124_au());
        teams.get(name).add(uuid);
        team.put(uuid, name);
        this.func_76185_a();
    }

    public void removePlayer(EntityPlayer p, UUID uid) {
        String name = team.get(p.func_110124_au());
        teams.get(name).remove(uid);
        team.remove(uid);
        this.func_76185_a();
    }

    public void removeTeam(String name) {
        for (UUID id : teams.get(name)) {
            team.remove(id);
        }
        teams.remove(name);
        teamOwner.remove(name);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        teams.clear();
        team.clear();
        String name = "";
        for (NBTTagCompound tagCompound : nbt.func_150295_c("Teams", 10)) {
            Iterator playerTagListIterator = tagCompound.func_150295_c("Player List", 10).iterator();
            ArrayList<UUID> uuidList = new ArrayList<UUID>();
            while (playerTagListIterator.hasNext()) {
                NBTTagCompound playerTag = (NBTTagCompound)playerTagListIterator.next();
                UUID id = UUID.fromString(playerTag.func_74779_i("uuid"));
                name = tagCompound.func_74779_i("Team Name");
                team.put(id, name);
                uuidList.add(id);
            }
            teams.put(name, uuidList);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList tagList = new NBTTagList();
        Iterator<String> iteratorTeams = teams.keySet().iterator();
        while (iteratorTeams.hasNext()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            String team = iteratorTeams.next();
            tagCompound.func_74778_a("Team Name", team);
            NBTTagList playerListTag = new NBTTagList();
            for (UUID id : teams.get(team)) {
                NBTTagCompound playerTag = new NBTTagCompound();
                playerTag.func_74778_a("uuid", id.toString());
                playerListTag.func_74742_a((NBTBase)playerTag);
            }
            tagCompound.func_74782_a("Player List", (NBTBase)playerListTag);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        compound.func_74782_a("Teams", (NBTBase)tagList);
        return compound;
    }

    public static WorldData get(World world) {
        MapStorage storage = world.func_175693_T();
        WorldData data = (WorldData)storage.func_75742_a(WorldData.class, "caliber");
        if (data == null) {
            data = new WorldData();
            world.func_72823_a("caliber", (WorldSavedData)data);
        }
        return data;
    }
}

