/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.util.handlers;

import com.ubalube.scifiaddon.commands.CommandModify;
import com.ubalube.scifiaddon.entity.EntityBandit;
import com.ubalube.scifiaddon.entity.EntityGhost;
import com.ubalube.scifiaddon.entity.EntityGoliath;
import com.ubalube.scifiaddon.entity.model.shields.ModelShield;
import com.ubalube.scifiaddon.init.EntityInit;
import com.ubalube.scifiaddon.init.ModBlocks;
import com.ubalube.scifiaddon.init.ModItems;
import com.ubalube.scifiaddon.util.IHasModel;
import com.ubalube.scifiaddon.util.IShield;
import com.ubalube.scifiaddon.util.handlers.ConfigHandler;
import com.ubalube.scifiaddon.util.handlers.RenderHandler;
import com.ubalube.scifiaddon.util.handlers.SoundHandler;
import com.ubalube.scifiaddon.util.handlers.TileEntityHandler;
import com.ubalube.scifiaddon.world.gen.WorldGenCustomStructures;
import com.ubalube.scifiaddon.world.gen.WorldGenOceanStructures;
import com.ubalube.scifiaddon.world.types.WorldTypeBadlands;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
        TileEntityHandler.registerTileEntities();
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (item instanceof IShield) {
                ModelShield shield = ((IShield)item).shieldModel();
                if (item == ModItems.BLITZSHIELD) {
                    RegistryHandler.createRender(item, shield, ":textures/models/shield/blitzshield.png");
                }
            }
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
        SoundHandler.registerSounds();
        EntityInit.registerProjectile();
        EntityInit.registerEntities();
        if (ConfigHandler.ServerSide.spawnStructures) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenOceanStructures(), (int)100);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenCustomStructures(), (int)100);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void preInitRegistriesOne() {
        RenderHandler.registerEntityRenders();
    }

    public static void initRegistries() {
        Biome[] spawnBiomes = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("desert"))};
        EntityRegistry.addSpawn(EntityBandit.class, (int)5, (int)4, (int)5, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])spawnBiomes);
        EntityRegistry.addSpawn(EntityGoliath.class, (int)ConfigHandler.ServerSide.spawnChance, (int)0, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])spawnBiomes);
        Biome[] spawnBiomes2 = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("ice_flats"))};
        EntityRegistry.addSpawn(EntityGhost.class, (int)30, (int)2, (int)4, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])spawnBiomes2);
    }

    public static void postInitRegistries() {
        WorldTypeBadlands BADLANDS = new WorldTypeBadlands();
    }

    public static void serverRegistries(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new CommandModify());
    }

    @SideOnly(value=Side.CLIENT)
    private static void createRender(Item item, final ModelShield s, final String resource) {
        item.setTileEntityItemStackRenderer(new TileEntityItemStackRenderer(){

            public void func_179022_a(ItemStack stack) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("caliber" + resource));
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
                s.render();
                GlStateManager.func_179121_F();
            }
        });
    }
}

