/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.util.packets;

import com.ubalube.scifiaddon.util.WorldData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageSaveData
implements IMessage {
    private NBTTagCompound tagTeam = new NBTTagCompound();

    public MessageSaveData() {
    }

    public MessageSaveData(Map<String, List<UUID>> teamsMap) {
        NBTTagList tagList = new NBTTagList();
        Iterator<String> iteratorTeams = teamsMap.keySet().iterator();
        while (iteratorTeams.hasNext()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            String team = iteratorTeams.next();
            tagCompound.func_74778_a("Team Name", team);
            NBTTagList playerListTag = new NBTTagList();
            for (UUID id : teamsMap.get(team)) {
                NBTTagCompound playerTag = new NBTTagCompound();
                playerTag.func_74778_a("uuid", id.toString());
                playerListTag.func_74742_a((NBTBase)playerTag);
            }
            tagCompound.func_74782_a("Player List", (NBTBase)playerListTag);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        this.tagTeam.func_74782_a("Teams", (NBTBase)tagList);
    }

    public void fromBytes(ByteBuf buf) {
        this.tagTeam = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagTeam);
    }

    public static class MessageHandler
    implements IMessageHandler<MessageSaveData, IMessage> {
        public IMessage onMessage(MessageSaveData message, MessageContext ctx) {
            NBTTagCompound nbt = message.tagTeam;
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldData.teams.clear();
                WorldData.team.clear();
                String name = "";
                for (NBTTagCompound tagCompound : nbt.func_150295_c("Teams", 10)) {
                    Iterator playerTagListIterator = tagCompound.func_150295_c("Player List", 10).iterator();
                    ArrayList<UUID> uuidList = new ArrayList<UUID>();
                    while (playerTagListIterator.hasNext()) {
                        NBTTagCompound playerTag = (NBTTagCompound)playerTagListIterator.next();
                        UUID id = UUID.fromString(playerTag.func_74779_i("uuid"));
                        AbstractClientPlayer p = (AbstractClientPlayer)FMLClientHandler.instance().getWorldClient().func_152378_a(id);
                        name = tagCompound.func_74779_i("Team Name");
                        WorldData.team.put(id, name);
                        uuidList.add(id);
                    }
                    WorldData.teams.put(name, uuidList);
                }
            });
            return null;
        }
    }
}

