/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.vehicles;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class VehicleHumvee
extends EntityCreature {
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(VehicleHumvee.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> MOVING = EntityDataManager.func_187226_a(VehicleHumvee.class, (DataSerializer)DataSerializers.field_187198_h);
    private float turretrotationyaw;
    private float turretrotationpitch;

    public VehicleHumvee(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.0f, 1.25f);
        this.field_70138_W = 1.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(125.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(125.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(MOVING);
    }

    private void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(MOVING, (Object)moving);
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187770_dm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187539_bB;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(MOVING, (Object)false);
    }

    protected void mountTo(EntityPlayer player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!super.func_184645_a(player, hand)) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b() == Items.field_151057_cb) {
                itemstack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
            }
            return true;
        }
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.3;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
            }
            Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            if (passenger != this.func_184179_bs()) {
                passenger.field_70177_z = this.field_70177_z;
                this.updateGunnerRotation(passenger);
            }
            if (passenger != this.func_184179_bs()) {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + 0.4, this.field_70161_v - (double)0.4f);
            } else {
                passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + this.func_70042_X() - (double)0.4f, this.field_70161_v + vec3d.field_72449_c);
            }
        }
    }

    public void updateGunnerRotation(Entity gunner) {
        this.turretrotationyaw = gunner.field_70177_z;
    }

    public float getGunnerRotationYaw() {
        return this.turretrotationyaw;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            this.field_70177_z = entitylivingbase.field_70177_z;
            if (forward <= 0.0f) {
                forward *= 0.25f;
                this.setMoving(true);
            }
            if (this.func_184186_bw()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(0.0f, vertical, forward);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

