/*
 * Decompiled with CFR 0.152.
 */
package com.ubalube.scifiaddon.world.gen;

import com.ubalube.scifiaddon.world.gen.WorldGenStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.biome.BiomeMushroomIsland;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.biome.BiomeSavanna;
import net.minecraft.world.biome.BiomeSnow;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomStructures
implements IWorldGenerator {
    public static final WorldGenStructures CHECKPOINT = new WorldGenStructures("checkpoint");
    public static final WorldGenStructures DUNE = new WorldGenStructures("dune");
    public static final WorldGenStructures LAB = new WorldGenStructures("laboratory");
    public static final WorldGenStructures LEGION = new WorldGenStructures("legion_1");
    public static final WorldGenStructures LEGIONBOSSROOM = new WorldGenStructures("legionbossroom");

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 2: {
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                this.generateStructure(new WorldGenStructures("checkpoint"), world, random, chunkX, chunkZ, 220, (Block)Blocks.field_150349_c, BiomeSavanna.class);
                this.generateStructure(new WorldGenStructures("dune"), world, random, chunkX, chunkZ, 470, (Block)Blocks.field_150354_m, BiomeDesert.class);
                this.generateStructure(new WorldGenStructures("laboratory"), world, random, chunkX, chunkZ, 470, (Block)Blocks.field_150349_c, BiomeSnow.class);
                this.generateStructure(new WorldGenStructures("legion_1"), world, random, chunkX, chunkZ, 470, (Block)Blocks.field_150349_c, BiomePlains.class);
                this.generateStructure(new WorldGenStructures("legionbossroom"), world, random, chunkX, chunkZ, 200, (Block)Blocks.field_150391_bh, BiomeMushroomIsland.class);
                break;
            }
        }
    }

    private void generateStructure(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = WorldGenCustomStructures.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() == WorldType.field_77138_c) {
            ++y;
        }
        if (classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

